<?php namespace Visiosoft\PaypalWebhooksExtension\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\UsersModule\User\Contract\UserInterface;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Contracts\Auth\Guard;
use Visiosoft\InboxModule\Event\InboxEvent;
use Visiosoft\PaypalWebhooksExtension\Events\OrderApproved;
use Visiosoft\PaypalWebhooksExtension\Events\OrderCancelled;
use Visiosoft\PaypalWebhooksExtension\Events\PaymentStarted;


class WebhookController extends PublicController
{
    public function saveLog($event_name, array $values)
    {
        $event_name = str_slug($event_name, '-');
        $file = fopen("log-paypal-$event_name-" . date('Y-m-d-H-i-s') . ".json", "w");
        fwrite($file, json_encode($values));
        fclose($file);

    }

    public function webhook()
    {
        $values = $this->request->all();

        $this->saveLog($this->request->event_type, $values);

        if ($this->request->event_type == "CHECKOUT.ORDER.APPROVED") {
            // Approved Event
            event(new OrderApproved($values));
        } elseif ($this->request->event_type == "PAYMENT.CAPTURE.PENDING") {
            // A payment capture completes.
            event(new PaymentStarted($values));
        } elseif (in_array($this->request->event_type, ["PAYMENT.ORDER.CANCELLED", "PAYMENT.CAPTURE.REFUNDED",
            "PAYMENT.SALE.REFUNDED", "PAYMENT.SALE.DENIED", "PAYMENT.CAPTURE.DENIED"])) {
            event(new OrderCancelled($values));
        }
    }

}
