<?php namespace Visiosoft\PaypalModule\Http\Controller;

use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Contracts\Events\Dispatcher;
use Illuminate\Http\Request;
use PayPal\Api\Amount;
use PayPal\Api\Details;
use PayPal\Api\Item;
use PayPal\Api\ItemList;
use PayPal\Api\Payer;
use PayPal\Api\Payment;
use PayPal\Api\Presentation;
use PayPal\Api\RedirectUrls;
use PayPal\Api\Transaction;
use PayPal\Api\WebProfile;
use PayPal\Auth\OAuthTokenCredential;
use PayPal\Exception\PayPalConnectionException;
use PayPal\Rest\ApiContext;
use PHPUnit\Exception;
use PHPUnit\TextUI\ResultPrinter;
use Srmklive\PayPal\Services\ExpressCheckout;
use Visiosoft\PaypalModule\Events\PaypalItems;
use Visiosoft\PaypalModule\Events\StatusItem;
use Visiosoft\PaypalModule\Payment\PaymentModel;

class PaypalController extends PublicController
{
    public $settings;
    public $model;
    private $config;

    public function __construct(PaymentModel $paymentModel)
    {
        $this->settings = app(SettingRepositoryInterface::class);
        $this->model = $paymentModel;

        //Client ID and Client Secret
        $client_id = $this->settings->value('visiosoft.module.paypal::paypal_client_id');
        $client_secret = $this->settings->value('visiosoft.module.paypal::paypal_client_secret');

        $apiContext = new ApiContext(
            new OAuthTokenCredential(
                $client_id,
                $client_secret
            )
        );
        $apiContext->setConfig(
            array(
                'mode' => $this->settings->value('visiosoft.module.paypal::mode'),
                'log.LogEnabled' => true,
                'log.FileName' => '../PayPal.log',
                'log.LogLevel' => 'DEBUG',
                'cache.enabled' => true,
            )
        );
        $this->config = $apiContext;
    }

    public function getConfig()
    {

    }

    public function getOptions()
    {

    }

    public function getData($key)
    {
        $item = $this->model->getItemWithKey($key);
        $item1 = new Item();
        $item1->setName($item->name)
            ->setCurrency(substr(setting_value('streams::currency'), 0, 3))
            ->setQuantity($item->quantity)
            ->setSku($item->id)
            ->setPrice($item->price);

        $data = array();
        array_push($data, $item1);

        return $data;
    }

    public function getSubTotal($items)
    {
        $SubTotal = 0;
        foreach ($items as $item) {
            $SubTotal += $item->price;
        }
        return $SubTotal;
    }

    public function payment($key)
    {
        //Item List
        $items = $this->getData($key);

        //URL Settings
        $return_url = url('/payment/paypal/result') . "?success=true&key=" . $key;
        $cancel_url = url('/payment/paypal/result') . "?success=false&key=" . $key;

        //SubTotal INT |/Tax INT |/Shipping INT |/Total INT |Currency STRING|/Payment Description STRING
        $SubTotal = $this->getSubTotal($items);
        $Tax = 0;
        $Shipping = 0;
        $Total = $SubTotal + $Tax + $Shipping;
        $Currency = substr(setting_value('streams::currency'), 0, 3);
        $Description = "Payment description";

        //Set Payment Method
        $payer = new Payer();
        $payer->setPaymentMethod("paypal");

        //Set Items
        $itemList = new ItemList();
        $itemList->setItems($items);

        //Set Details
        $details = new Details();
        $details
            ->setShipping($Shipping)
            ->setTax($Tax)
            ->setSubtotal($SubTotal);

        //Set Amount
        $amount = new Amount();
        $amount
            ->setCurrency($Currency)
            ->setTotal($Total)
            ->setDetails($details);

        //Set Transaction
        $transaction = new Transaction();
        $transaction
            ->setAmount($amount)
            ->setItemList($itemList)
            ->setDescription($Description)
            ->setInvoiceNumber(uniqid());

        $redirectUrls = new RedirectUrls();

        $redirectUrls
            ->setReturnUrl($return_url)
            ->setCancelUrl($cancel_url);

        $payment = new Payment();

        $payment->setIntent("sale")
            ->setPayer($payer)
            ->setRedirectUrls($redirectUrls)
            ->setExperienceProfileId('XP-49K5-P74K-SLFB-5M46')
            ->setTransactions(array($transaction));

        try {
            $payment->create($this->config);

        } catch (PayPalConnectionException $ex) {
            return json_decode($ex->getData(), true);
            exit(1);
        }

        $approvalUrl = $payment->getApprovalLink();

        //Redirect Payment Page
        return redirect($approvalUrl);
    }

    public function result(Request $request, Dispatcher $events)
    {
        if (isset($request->paymentId)) {

            try {
                $payment = Payment::get($request->paymentId, $this->config);
            } catch (PayPalConnectionException $ex) {
//                return json_decode($ex->getData(), true);
                $item = $events->dispatch(new StatusItem($request->key, "false"));
                return redirect(url(end($item)->return_url));
            }

            if ($payment->getState() == "created") {

                $item = $events->dispatch(new StatusItem($request->key, "true"));
                return redirect(url(end($item)->return_url));

            }
        }
        $item = $events->dispatch(new StatusItem($request->key, "false"));
        return redirect(url(end($item)->return_url));
    }
}
