(function() {
    "use strict";

    var stripe = Stripe(publishableAPIKey);
    var elements = stripe.elements({
        fonts: [
            {
                cssSrc: "https://rsms.me/inter/inter-ui.css"
            }
        ],
        locale: 'auto'
    });

    var cardElement = elements.create("card", {
        hidePostalCode: true,
        style: {
            base: {
                color: "#32325D",
                fontWeight: 500,
                fontFamily: "Inter UI, Open Sans, Segoe UI, sans-serif",
                fontSize: "16px",
                fontSmoothing: "antialiased",

                "::placeholder": {
                    color: "#CFD7DF"
                }
            },
            invalid: {
                color: "#E25950"
            }
        }
    });

    cardElement.mount('#card-element');

    var errorElement = $('#card-errors');
    cardElement.addEventListener('change', function(event) {
        if (event.error) {
            errorElement.addClass('visible');
            errorElement.find('.message').text(event.error.message);
        } else {
            errorElement.removeClass('visible');
        }
    });

    var cell = $('.cell');
    var form = document.getElementById('subscription-form');

    form.addEventListener('submit', function(event) {
        event.preventDefault();

        cell.addClass('submitting');

        stripe.createPaymentMethod({
            type: 'card',
            card: cardElement,
            billing_details: {
                email: userEmail,
            },
        }).then(stripePaymentMethodHandler);
    });

    function stripePaymentMethodHandler(result) {
        if (result.error) {
            errorElement.addClass('visible');
            errorElement.find('.message').text(result.error.message);
            cell.removeClass("submitting");
        } else {
            fetch('/payment/stripe/respond', {
                method: 'post',
                headers: {'Content-Type': 'application/json'},
                body: JSON.stringify({
                    payment_method: result.paymentMethod.id
                }),
            }).then(function(result) {
                return result.json();
            }).then(function(subscription) {
                if (subscription.error) {
                    errorElement.addClass('visible');
                    errorElement.find('.message').text(subscription.error.message);
                    cell.removeClass("submitting");
                } else {
                    const { latest_invoice } = subscription;
                    const { payment_intent } = latest_invoice;

                    if (payment_intent) {
                        const { client_secret, status } = payment_intent;

                        if (status === 'requires_action') {
                            stripe.confirmCardPayment(client_secret).then(function(result) {
                                if (result.error) {
                                    errorElement.addClass('visible');
                                    errorElement.find('.message').text(result.error.message);
                                    cell.removeClass("submitting");
                                } else {
                                    paymentSuccess().then((result) => {
                                        if (result.error) {
                                            errorElement.addClass('visible');
                                            errorElement.find('.message').text(result.error.message);
                                            cell.removeClass("submitting");
                                        } else {
                                            cell.addClass("submitted");
                                        }
                                    });
                                }
                            });
                        } else {
                            paymentSuccess().then((result) => {
                                if (result.error) {
                                    errorElement.addClass('visible');
                                    errorElement.find('.message').text(result.error.message);
                                    cell.removeClass("submitting");
                                } else {
                                    cell.addClass("submitted");
                                }
                            });
                        }
                    }
                }
            });
        }
    }

    function paymentSuccess() {
        return fetch('/payment/stripe/success', {
            method: 'get',
            headers: {'Content-Type': 'application/json'},
        }).then(function(result) {
            return result.json();
        })
    }
})();