<?php namespace Visiosoft\PaymentStripeModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Model\PaymentStripe\PaymentStripePaymentNameEntryModel;
use Visiosoft\CartsModule\Cart\Event\CartsPay;
use Visiosoft\PaymentStripeModule\Listener\PaymentType;
use Visiosoft\PaymentStripeModule\PaymentName\Contract\PaymentNameRepositoryInterface;
use Visiosoft\PaymentStripeModule\PaymentName\PaymentNameModel;
use Visiosoft\PaymentStripeModule\PaymentName\PaymentNameRepository;

class PaymentStripeModuleServiceProvider extends AddonServiceProvider
{

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/payment_stripe' => 'Visiosoft\PaymentStripeModule\Http\Controller\Admin\PaymentNameController@index',
        'admin/payment_stripe/create' => 'Visiosoft\PaymentStripeModule\Http\Controller\Admin\PaymentNameController@create',
        'admin/payment_stripe/edit/{id}' => 'Visiosoft\PaymentStripeModule\Http\Controller\Admin\PaymentNameController@edit',

        'payment/stripe' => 'Visiosoft\PaymentStripeModule\Http\Controller\StripeController@paymentForm',
        'payment/stripe/success' => 'Visiosoft\PaymentStripeModule\Http\Controller\StripeController@paymentSuccess',
        'payment/stripe/respond' => [
            'uses' => 'Visiosoft\PaymentStripeModule\Http\Controller\StripeController@paymentStripe',
            'middleware' => 'auth'
        ]
    ];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        CartsPay::class =>
            [
                PaymentType::class,
            ]
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        PaymentStripePaymentNameEntryModel::class => PaymentNameModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        PaymentNameRepositoryInterface::class => PaymentNameRepository::class,
    ];

}
