<?php namespace Visiosoft\PaymentStripeModule\Listener;

use Visiosoft\CartsModule\Cart\Event\CartsPay;
use Visiosoft\PaymentStripeModule\PaymentName\Contract\PaymentNameRepositoryInterface;

class PaymentType
{

    private $paymentNameRepository;

    public function __construct(PaymentNameRepositoryInterface $paymentNameRepository)
    {
        $this->paymentNameRepository = $paymentNameRepository;
    }

    public function handle(CartsPay $event)
    {
        $payment = 'stripe';
        $paymentName = $this->paymentNameRepository->first();
        if ($paymentName) {
            $paymentName = $paymentName->payment_name;
        } else {
            $paymentName = setting_value('visiosoft.module.payment_stripe::payment_name');
        }
        return [
            'payment' => $payment,
            'paymentName' => $paymentName,
        ];
    }
}
