<?php namespace Visiosoft\PaymentStripeModule\Http\Controller;

use Omnipay\Omnipay;
use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\CountryFieldType\Location\LocationModel;
use Illuminate\Support\Facades\Auth;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\CartsModule\Cart\Command\TotalCart;
use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Omnipay\Common\CreditCard;
use Illuminate\Http\Request;
use Visiosoft\LocationModule\City\CityModel;
use Visiosoft\LocationModule\Country\CountryModel;
use Visiosoft\OrdersModule\Order\OrderModel;
use Visiosoft\OrdersModule\Test\Unit\Order\OrderModelTest;
use Visiosoft\ProfileModule\Adress\AdressModel;
use Visiosoft\ProfileModule\Profile\ProfileModel;

class StripeController extends PublicController
{
    public function paymentForm()
    {
        return $this->view->make('visiosoft.module.payment_stripe::stripe/form');
    }


    public function paymentStripe(Request $request, SettingRepositoryInterface $settings)
    {
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }
        $OrderModel = new OrderModel();
        $Order = $OrderModel->getLastOrderByUser();
        $AddressModel = new AdressModel();
        $address = $AddressModel->getAdress($Order->bill_address_id)->first();
        $CountryModel = new CountryModel();
        $country = $CountryModel->getCountry($address->country_id);
        $CityModel = new CityModel();
        $city = $CityModel->getCities($address->city);
        $cart = $this->dispatch(new GetCart());
        $this->dispatch(new TotalCart($cart));

        $gateway = Omnipay::create('Stripe');
        $gateway->setApiKey($settings->value('visiosoft.module.payment_stripe::stripe_setApiKey'));
        
        // Example form data
        $formData = [
            'number' => $request->ccno,
            'expiryMonth' => $request->expirationdateM,
            'expiryYear' => $request->expirationdateY,
            'cvv' => $request->ccv
        ];
        
        // Send purchase request
        $response = $gateway->purchase(
            [
                'amount' => $cart->total,
                'currency' => 'USD',
                'card' => $formData
            ]
        )->send();
        
        if ($response->isSuccessful()) {
            return redirect('payment/success/iyzico');
        } else {
            return redirect('payment/fail');
        }
    }
}