<?php namespace Visiosoft\PaymentPaytrModule\Http\Controller;

use Anomaly\CountryFieldType\Location\LocationModel;
use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Support\Facades\Auth;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\CartsModule\Cart\Command\TotalCart;
use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Omnipay\Omnipay;
use Omnipay\Common\CreditCard;
use Visiosoft\LocationModule\City\CityModel;
use Visiosoft\LocationModule\Country\CountryModel;
use Visiosoft\OrdersModule\Order\Contract\OrderRepositoryInterface;
use Visiosoft\OrdersModule\Order\OrderModel;
use Visiosoft\OrdersModule\Test\Unit\Order\OrderModelTest;
use Visiosoft\ProfileModule\Adress\AdressModel;

class PaytrController extends PublicController
{
    private $order_model;
    private $address_model;
    private $country_model;
    private $city_model;
    private $settings;

    public function __construct(
        OrderModel $orderModel,
        AdressModel $adressModel,
        CityModel $cityModel,
        SettingRepositoryInterface $settingRepository,
        CountryModel $countryModel
    )
    {
        $this->order_model = $orderModel;
        $this->address_model = $adressModel;
        $this->country_model = $countryModel;
        $this->city_model = $cityModel;
        $this->settings = $settingRepository;
        parent::__construct();
    }

    public function paymentPaytr()
    {
        $order_id = $this->request->cookie('order_id');
        $bill_id = $this->request->cookie('bill');

        $address = $this->address_model->getAdress($bill_id)->first();
        $country = $this->country_model->getCountry($address->country_id);
        $city = $this->city_model->getCities($address->city);

        $cart = $this->dispatch(new GetCart());
        $this->dispatch(new TotalCart($cart));

        $merchant_id = $this->settings->value('visiosoft.module.payment_paytr::store_number');
        $merchant_key = $this->settings->value('visiosoft.module.payment_paytr::store_password');
        $merchant_salt = $this->settings->value('visiosoft.module.payment_paytr::store_secret_key');

        $email = Auth::user()->email;
        $payment_amount = $cart->total;
        $merchant_oid = $order_id;
        $user_name = "$address->adress_first_name $address->adress_last_name";
        $user_address = "$city->name / $country->name / $address->adress_content";
        $user_phone = $address->adress_gsm_phone;
        $merchant_ok_url = url('payment/success/paytr');
        $merchant_fail_url = url('payment/fail');
        $user_basket = base64_encode(json_encode(array(
            array("Product 1", $cart->total, 1)
        )));
        #
        /* EXAMPLE $user_basket creation - You can duplicate arrays per each product
        $user_basket = base64_encode(json_encode(array(
            array("Sample Product 1", "18.00", 1), // 1st Product (Product Name - Unit Price - Piece)
            array("Sample Product 2", "33.25", 2), // 2nd Product (Product Name - Unit Price - Piece)
            array("Sample Product 3", "45.42", 1)  // 3rd Product (Product Name - Unit Price - Piece)
        )));
         */

        if (isset($_SERVER["HTTP_CLIENT_IP"])) {
            $ip = $_SERVER["HTTP_CLIENT_IP"];
        } elseif (isset($_SERVER["HTTP_X_FORWARDED_FOR"])) {
            $ip = $_SERVER["HTTP_X_FORWARDED_FOR"];
        } else {
            $ip = $_SERVER["REMOTE_ADDR"];
        }

        $user_ip = $ip;
        $timeout_limit = "30";
        $debug_on = $this->settings->value('visiosoft.module.payment_paytr::debug_on');
        $debug_on = $debug_on ? 1 : 0;
        $test_mode = $this->settings->value('visiosoft.module.payment_paytr::test_mode');
        $test_mode = $test_mode ? 1 : 0;
        $no_installment = $this->settings->value('visiosoft.module.payment_paytr::no_installment');
        $no_installment = $no_installment ? 1 : 0;
        $max_installment = $this->settings->value('visiosoft.module.payment_paytr::max_installment');
        $currency = setting_value('streams::currency');
        if ($currency !== 'USD' || $currency !== 'TRY' || $currency !== 'EUR' || $currency !== 'GBP' || $currency !== 'RUB') {
            $this->messages->error(trans('visiosoft.module.payment_paytr::message.currency_not_supported'));
            return back();
        }

        $hash_str = $merchant_id . $user_ip . $merchant_oid . $email . $payment_amount . $user_basket . $no_installment
            . $max_installment . $currency . $test_mode;
        $paytr_token = base64_encode(
            hash_hmac('sha256', $hash_str . $merchant_salt, $merchant_key, true)
        );

        $post_vals = array(
            'merchant_id' => $merchant_id,
            'user_ip' => $user_ip,
            'merchant_oid' => $merchant_oid,
            'email' => $email,
            'payment_amount' => $payment_amount,
            'paytr_token' => $paytr_token,
            'user_basket' => $user_basket,
            'debug_on' => $debug_on,
            'no_installment' => $no_installment,
            'max_installment' => $max_installment,
            'user_name' => $user_name,
            'user_address' => $user_address,
            'user_phone' => $user_phone,
            'merchant_ok_url' => $merchant_ok_url,
            'merchant_fail_url' => $merchant_fail_url,
            'timeout_limit' => $timeout_limit,
            'currency' => $currency,
            'test_mode' => $test_mode
        );

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://www.paytr.com/odeme/api/get-token");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_vals);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_FRESH_CONNECT, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 20);
        $result = @curl_exec($ch);

        if (curl_errno($ch)) {
            $this->messages->error("PAYTR IFRAME connection error. err:" . curl_error($ch));
            return back();
        }

        curl_close($ch);

        $result = json_decode($result, 1);

        if ($result['status'] == 'success') {
            $token = $result['token'];
        } else {
            $this->messages->error("PAYTR IFRAME failed. reason:" . $result['reason']);
            return back();
        }

        return $this->view->make('visiosoft.module.payment_paytr::paytr/redirect', compact('token'));
    }

    public function returnPaytr(OrderRepositoryInterface $orderRepository)
    {
        $post = $_POST;

        $merchant_key = $this->settings->value('visiosoft.module.payment_paytr::store_password');
        $merchant_salt = $this->settings->value('visiosoft.module.payment_paytr::store_secret_key');

        $hash = base64_encode(hash_hmac('sha256', $post['merchant_oid'] . $merchant_salt . $post['status'] . $post['total_amount'], $merchant_key, true));

        if ($hash != $post['hash']) {
            die('PAYTR notification failed: bad hash');
        }

        if ($post['status'] == 'success') {
            $orderRepository->approveOrder($post['merchant_oid']);
        } else {
            $orderRepository->rejectOrder($post['merchant_oid']);
        }

        echo "OK";
        exit;
    }
}