<?php

namespace Visiosoft\PaymentPaytrExtension\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\PaymentPaytrExtension\Event\PaymentFail;
use Visiosoft\PaymentPaytrExtension\Event\PaymentResult;
use Visiosoft\PaymentPaytrExtension\Event\PaymentSuccess;
use Visiosoft\PaymentPaytrExtension\Helpers\Credentials;

class WebhookController extends PublicController
{
    private Credentials $credentials;

    public function __construct()
    {
        $this->credentials = new Credentials();
        parent::__construct();
    }

    public function paymentResult()
    {
        $request = request()->post();
        $paymentID = $request['merchant_oid'];
        if (!$this->verifyToken($request['hash'], $paymentID, $request['status'], $request['total_amount'])) {
            die('PAYTR notification failed: bad hash');
        }

        $status = 'success';
        if ($request['status'] != 'success') {
            $status = "fail";
        }
        event(new PaymentResult($paymentID,$status));

        echo "OK";
    }

    private function verifyToken($requestToken, $paymentID, $paymentStatus, $paymentAmount)
    {
        $hash = base64_encode(hash_hmac('sha256', $paymentID . $this->credentials->getMerchantSalt() . $paymentStatus . $paymentAmount, $this->credentials->getMerchantKey(), true));
        return $requestToken == $hash;
    }
}