<?php

namespace Visiosoft\PaymentPaytrExtension\Models;

class Items
{
    private string $encodedItems;
    private array $rawItems;

    public function __construct(array $items)
    {
        $formattedItems = [];

        foreach ($items as $item) {
            $formattedItems[] = [
                $item['name'], $item['total'], $item['quantity']
            ];
        }

        $this->rawItems = $formattedItems;
        $this->encodedItems = $this->encodeItems($formattedItems);
    }

    private function encodeItems($items): string
    {
        return base64_encode(json_encode($items));
    }

    public function getEncodedItems(): string
    {
        return $this->encodedItems;
    }

    public function getItems(): array
    {
        return $this->rawItems;
    }

}