<?php namespace Visiosoft\PaymentPaytrExtension;

use Anomaly\Streams\Platform\Addon\Extension\Extension;
use Visiosoft\PaymentPaytrExtension\Helpers\Log;
use Visiosoft\PaymentPaytrExtension\Models\Currency;
use Visiosoft\PaymentPaytrExtension\Models\Items;

class PaymentPaytrExtension extends Extension
{

    /**
     * This extension provides...
     *
     * This should contain the dot namespace
     * of the addon this extension is for followed
     * by the purpose.variation of the extension.
     *
     * For example visiosoft.extension.payment::gateway.payment_paytr
     *
     * @var null|string
     */
    protected $provides = 'visiosoft.module.payment::payment_provider.paytr';

    protected string $successCallback;
    protected string $failCallback;


    public function setSuccessCallback($callback)
    {
        $this->successCallback = $callback;
    }

    public function setFailCallback($callback)
    {
        $this->failCallback = $callback;
    }

    public function payByIframe($buyerName, $buyerSurname, $buyerEmail, $buyerPhone, $buyerAddress, $total, $currency, $invoiceID, $items): array
    {
        $total = $total * 100;
        try {
            $pay = new Pay(
                $this->successCallback,
                $this->failCallback,
                $buyerName,
                $buyerSurname,
                $buyerEmail,
                $buyerPhone,
                $buyerAddress,
                $total,
                new Currency(strtoupper($currency)),
                $invoiceID,
                new Items($items));

            $response = $pay->payByIframe();
            if ($response['status'] == "success") {
                $serviceResponse['status'] = 'success';
                $serviceResponse['payment_redirect_uri'] = route('visiosoft.extension.payment_paytr::iframe', ['token' => $response['token']]);

            } else {
                $serviceResponse['status'] = 'fail';
                $serviceResponse['service_message'] = $response['reason'];
            }


        } catch (\Exception $e) {
            (new Log())->createLog($e);
            $serviceResponse['status'] = 'fail';
            $serviceResponse['service_message'] = "Payment Error";
        }

        return $serviceResponse;
    }

    public
    function payByCard($card_number, $card_holder, $exp_year, $exp_month, $cvv, $total, $items, $currency, $invoice_id, $buyer_name, $buyer_surname)
    {
        //TODO::Create payByCard function and set response according to function content
        $serviceResponse['status'] = 'fail';
        $serviceResponse['service_message'] = "Function is not ready";
        $serviceResponse['error_code'] = '';
        return $serviceResponse;
    }

    /**
     * @param string $providerUserID
     * @param string $defaultCardID
     * @param float $price
     * @param string $currency
     * @param array $items (Accepted Values) => [['name','description','price','quantity','tax','tax_rate','taxed_price','discount','discounted_price','shipping','subtotal','total']]
     * @param array $buyer (Accepted Values) => [id, first_name, last_name, email, phone]
     * @param string $invoice_id
     * @return array
     */

    public
    function payBySavedCard(string $providerUserID, string $defaultCardID, float $price, string $currency = '', array $items = [], array $buyer = [], string $invoice_id = ''): array
    {
        //TODO::Create payBySavedCard function and set response according to function content
        $serviceResponse['status'] = 'fail';
        $serviceResponse['service_message'] = "Function is not ready";
        $serviceResponse['error_code'] = '';
        return $serviceResponse;
    }


    /**
     * @param string $paymentIntentID
     * @param string $paymentID
     * @return array|bool
     */
    public
    function refund(string $paymentIntentID, string $paymentID)
    {
        //TODO::Create refund function and set response according to function content
        $serviceResponse['status'] = 'fail';
        $serviceResponse['service_message'] = "Function is not ready";
        $serviceResponse['error_code'] = '';
        return $serviceResponse;
    }

}
