<?php

namespace Visiosoft\PaymentPaytrExtension;

use Visiosoft\PaymentPaytrExtension\Helpers\Client;
use Visiosoft\PaymentPaytrExtension\Helpers\Credentials;
use Visiosoft\PaymentPaytrExtension\Helpers\Request;
use Visiosoft\PaymentPaytrExtension\Helpers\Settings;
use Visiosoft\PaymentPaytrExtension\Models\Currency;
use Visiosoft\PaymentPaytrExtension\Models\Items;

class Pay
{
    private Credentials $credentials;
    private Settings $settings;
    private Client $client;
    private string $successCallback;
    private string $failCallback;
    private string $buyerName;
    private string $buyerSurname;
    private string $buyerEmail;
    private string $buyerPhone;
    private string $buyerAddress;
    private int $totalAmount;
    private Currency $currency;
    private string $invoice_id;
    private Items $items;

    /**
     * @param $successCallback
     * @param $failCallback
     * @param $buyerName
     * @param $buyerSurname
     * @param $buyerEmail
     * @param $buyerPhone
     * @param $totalAmount
     * @param $currency
     * @param $invoice_id
     * @param $items
     */
    public function __construct($successCallback, $failCallback, $buyerName, $buyerSurname, $buyerEmail, $buyerPhone, $buyerAddress, $totalAmount, $currency, $invoice_id, $items)
    {
        $this->credentials = new Credentials();
        $this->client = new Client();
        $this->settings = new Settings();
        $this->successCallback = $successCallback;
        $this->failCallback = $failCallback;
        $this->buyerName = $buyerName;
        $this->buyerSurname = $buyerSurname;
        $this->buyerEmail = $buyerEmail;
        $this->buyerPhone = $buyerPhone;
        $this->buyerAddress = $buyerAddress;
        $this->totalAmount = $totalAmount;
        $this->currency = $currency;
        $this->invoice_id = $invoice_id;
        $this->items = $items;
    }

    /**
     * @return string
     */
    private function getBuyerName(): string
    {
        return $this->buyerName . " " . $this->buyerSurname;
    }

    /**
     * @return string
     */
    private function generateToken(): string
    {
        return base64_encode(hash_hmac('sha256', $this->generateHash() . $this->credentials->getMerchantSalt(), $this->credentials->getMerchantKey(), true));
    }

    private function generateHash(): string
    {
        return $this->credentials->getMerchantID() .
            $this->client->getClientIp() .
            $this->invoice_id .
            $this->buyerEmail .
            $this->totalAmount .
            $this->items->getEncodedItems() .
            $this->settings->getInstallment() .
            $this->settings->getInstallmentLimit() .
            $this->currency->getValue() .
            $this->settings->getTestMode();
    }

    /**
     * @return mixed|void
     */
    public function payByIframe()
    {
        $params = [
            'merchant_id' => $this->credentials->getMerchantID(),
            'user_ip' => $this->client->getClientIp(),
            'merchant_oid' => $this->invoice_id,
            'email' => $this->buyerEmail,
            'payment_amount' => $this->totalAmount,
            'paytr_token' => $this->generateToken(),
            'user_basket' => $this->items->getEncodedItems(),
            'debug_on' => $this->settings->getDebugMode(),
            'no_installment' => $this->settings->getInstallment(),
            'max_installment' => $this->settings->getInstallmentLimit(),
            'user_name' => $this->getBuyerName(),
            'user_address' => $this->buyerAddress,
            'user_phone' => $this->buyerPhone,
            'merchant_ok_url' => $this->successCallback,
            'merchant_fail_url' => $this->failCallback,
            'timeout_limit' => $this->settings->getTimeoutLimit(),
            'currency' => $this->currency->getValue(),
            'test_mode' => $this->settings->getTestMode()
        ];

        return (new Request())->request($this->settings->getApiIframeUrl(), $params);
    }

}