<?php namespace Visiosoft\PaymentPaypalModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Support\Facades\Auth;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\CartsModule\Cart\Command\TotalCart;
use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Omnipay\Omnipay;
use Omnipay\Common\CreditCard;

/**
 * Class CartsController
 *
 * @link          http://openclassify.com/
 * @author        OpenClassify, Inc. <support@openclassify.com>
 * @author        Visiosoft Inc <support@openclassify.com>
 * @package       Visiosoft\CartsModule\Http\Controller
 */
class PaypalController extends PublicController
{
    public function paymentPaypal(SettingRepositoryInterface $settings)
    {
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }
        $cart = $this->dispatch(new GetCart());
        $this->dispatch(new TotalCart($cart));
        $params = array(
            'cancelUrl' => url('payment/fail'),
            'returnUrl' => url('payment/success/paypal'),
            'amount' => $cart->total,
        );
        $testmode = true;
        if ($settings->value('visiosoft.module.payment_paypal::paypal_testmode') != 1) {
            $testmode = false;
        }
        $gateway = Omnipay::create('PayPal_Express');
        $gateway->setUsername($settings->value('visiosoft.module.payment_paypal::paypal_username'));
        $gateway->setPassword($settings->value('visiosoft.module.payment_paypal::paypal_password'));
        $gateway->setSignature($settings->value('visiosoft.module.payment_paypal::paypal_signature'));
        $gateway->setTestMode($testmode);
        //Stock Control
        foreach ($cart->items as $item) {
            if ($item->entry_type == 'Visiosoft\AdvsModule\Adv\AdvModel') {
                $advModel = new AdvModel();
                $response_control = $advModel->stockControl($item->entry_id, $item->quantity);
                if ($response_control == "false") {
                    return redirect('/cart');
                    die;
                }
            }
        }
        $response = $gateway->purchase($params)->send();
        return redirect($response->redirect());
    }
}
