<?php namespace Visiosoft\PaymentIyzicompModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Model\PaymentIyzicomp\PaymentIyzicompPaymentItemsEntryModel;
use Visiosoft\PaymentIyzicompModule\PaymentItem\Contract\PaymentItemRepositoryInterface;
use Visiosoft\PaymentIyzicompModule\PaymentItem\PaymentItemModel;
use Visiosoft\PaymentIyzicompModule\PaymentItem\PaymentItemRepository;
use Visiosoft\PaymentIyzicompModule\Submerchant\Contract\SubmerchantRepositoryInterface;
use Visiosoft\PaymentIyzicompModule\Submerchant\SubmerchantRepository;
use Anomaly\Streams\Platform\Model\PaymentIyzicomp\PaymentIyzicompSubmerchantsEntryModel;
use Visiosoft\PaymentIyzicompModule\Submerchant\SubmerchantModel;

class PaymentIyzicompModuleServiceProvider extends AddonServiceProvider
{
    protected $routes = [
        'admin/payment_iyzicomp'           => 'Visiosoft\PaymentIyzicompModule\Http\Controller\Admin\SubmerchantsController@index',
        'admin/payment_iyzicomp/create'    => 'Visiosoft\PaymentIyzicompModule\Http\Controller\Admin\SubmerchantsController@create',
        'admin/payment_iyzicomp/edit/{id}' => 'Visiosoft\PaymentIyzicompModule\Http\Controller\Admin\SubmerchantsController@edit',
    ];

    protected $listeners = [
        'Visiosoft\PaymentIyzicoModule\Events\IyziciPaymentCreated' => [
            'Visiosoft\PaymentIyzicompModule\Listeners\CreatePaymentItems'
        ],
        'Visiosoft\OrdersModule\Events\OrderDelivered' => [
            'Visiosoft\PaymentIyzicompModule\Listeners\CreateApprovalRequest'
        ],
        'Anomaly\Streams\Platform\Ui\Table\Event\TableIsQuerying' => [
            'Visiosoft\PaymentIyzicompModule\Listeners\AddShipmentDeliveredButton'
        ]
    ];

    protected $aliases = [
        //'Example' => Visiosoft\PaymentIyzicompModule\Example::class
    ];

    protected $bindings = [
        PaymentIyzicompSubmerchantsEntryModel::class => SubmerchantModel::class,
        PaymentIyzicompPaymentItemsEntryModel::class => PaymentItemModel::class,
    ];

    protected $singletons = [
        SubmerchantRepositoryInterface::class => SubmerchantRepository::class,
        PaymentItemRepositoryInterface::class => PaymentItemRepository::class,
    ];
}
