<?php namespace Visiosoft\PaymentIyzicompModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Model\PaymentIyzicomp\PaymentIyzicompPaymentItemsEntryModel;
use Visiosoft\PaymentIyzicompModule\PaymentItem\Contract\PaymentItemRepositoryInterface;
use Visiosoft\PaymentIyzicompModule\PaymentItem\PaymentItemModel;
use Visiosoft\PaymentIyzicompModule\PaymentItem\PaymentItemRepository;
use Visiosoft\PaymentIyzicompModule\Submerchant\Contract\SubmerchantRepositoryInterface;
use Visiosoft\PaymentIyzicompModule\Submerchant\SubmerchantRepository;
use Anomaly\Streams\Platform\Model\PaymentIyzicomp\PaymentIyzicompSubmerchantsEntryModel;
use Visiosoft\PaymentIyzicompModule\Submerchant\SubmerchantModel;

class PaymentIyzicompModuleServiceProvider extends AddonServiceProvider
{

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/payment_iyzicomp'           => 'Visiosoft\PaymentIyzicompModule\Http\Controller\Admin\SubmerchantsController@index',
        'admin/payment_iyzicomp/create'    => 'Visiosoft\PaymentIyzicompModule\Http\Controller\Admin\SubmerchantsController@create',
        'admin/payment_iyzicomp/edit/{id}' => 'Visiosoft\PaymentIyzicompModule\Http\Controller\Admin\SubmerchantsController@edit',
    ];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        'Visiosoft\PaymentIyzicoModule\Events\IyziciPaymentCreated' => [
            'Visiosoft\PaymentIyzicompModule\Listeners\CreatePaymentItems'
        ],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\PaymentIyzicompModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        PaymentIyzicompSubmerchantsEntryModel::class => SubmerchantModel::class,
        PaymentIyzicompPaymentItemsEntryModel::class => PaymentItemModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        SubmerchantRepositoryInterface::class => SubmerchantRepository::class,
        PaymentItemRepositoryInterface::class => PaymentItemRepository::class,
    ];

}
