<?php namespace Visiosoft\PaymentIyzicompModule\Listeners;

use Anomaly\Streams\Platform\Ui\Table\Event\TableIsQuerying;
use Visiosoft\OrdersModule\Order\Contract\OrderInterface;
use Visiosoft\OrdersModule\Order\Table\OrderTableBuilder;

class AddShipmentDeliveredButton
{
    public function handle(TableIsQuerying $event)
    {
        $builder = $event->getBuilder();

        if (get_class($builder) == OrderTableBuilder::class) {
            $this->addShipmentDeliveredButton($builder);
        }
    }

    protected function addShipmentDeliveredButton(OrderTableBuilder $builder)
    {
        $buttons = $builder->getButtons();
        $buttons = array_merge([
            'mark_as_delivered' => [
                'href' => function (OrderInterface $entry) {
                    $hasUndelivered = $entry->details->where('status', '<>', 'paid_buyer')->first();
                    return "/admin/orders/delivered/" . ($hasUndelivered ? $entry->getId() : '#');
                },
                'class' => function (OrderInterface $entry) {
                    $hasUndelivered = $entry->details->where('status', '<>', 'paid_buyer')->first();
                    return $hasUndelivered ? 'btn btn-success' : 'btn btn-warning';
                },
                'text' => function (OrderInterface $entry) {
                    $hasUndelivered = $entry->details->where('status', '<>', 'paid_buyer')->first();
                    return $hasUndelivered
                        ? trans('visiosoft.module.orders::field.mark_delivered')
                        : trans('visiosoft.module.orders::field.delivered.name');
                },
                'disabled' => function (OrderInterface $entry) {
                    $hasUndelivered = $entry->details->where('status', '<>', 'paid_buyer')->first();
                    return !$hasUndelivered;
                },
            ],
        ], $buttons);
        $builder->setButtons($buttons);
}
}