<?php namespace Visiosoft\PaymentIyzicompModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\PaymentIyzicompModule\Submerchant\Contract\SubmerchantRepositoryInterface;

class SubmerchantsController extends PublicController
{
    private $submerchantRepository;

    public function __construct(
        SubmerchantRepositoryInterface $submerchantRepository
    )
    {
        parent::__construct();
        $this->submerchantRepository = $submerchantRepository;
    }

    public function getSubmerchant($store, $options)
    {
        // Check required fields
        if (!$store->iban_number) {
            throw new \Exception(trans('visiosoft.module.payment_iyzicomp::message.store_uncompleted_info', ['missing' => 'iban']));
        } elseif (!$store->user->identification_number) {
            throw new \Exception(trans('visiosoft.module.payment_iyzicomp::message.store_owner_uncompleted_info',
	            ['missing' => trans('visiosoft.module.payment_iyzicomp::field.user_id')]));
        }

        $subMerchant = $this->submerchantRepository->findBy('store_id', $store->id);
        if (!$subMerchant) {
            $subMerchant = $this->submerchantRepository->create([
                'store_id' => $store->id,
            ]);

            $request = new \Iyzipay\Request\CreateSubMerchantRequest();
            $request->setSubMerchantExternalId($subMerchant->id);
            $request->setSubMerchantType(\Iyzipay\Model\SubMerchantType::PERSONAL);
            $request = $this->setRequestParams($request, $store);
            $iyzicoSubMerchant = \Iyzipay\Model\SubMerchant::create($request, $options);

            if ($iyzicoSubMerchant->getStatus() === 'failure') {
                $subMerchant->delete();
                throw new \Exception($iyzicoSubMerchant->getErrorMessage());
            } else {
                $subMerchant->update([
                    'key' => $iyzicoSubMerchant->getSubMerchantKey()
                ]);
            }
        } else {
            $request = new \Iyzipay\Request\UpdateSubMerchantRequest();
            $request->setSubMerchantKey($subMerchant->key);
            $request = $this->setRequestParams($request, $store);
            $iyzicoSubMerchant = \Iyzipay\Model\SubMerchant::update($request, $options);

            if ($iyzicoSubMerchant->getStatus() === 'failure') {
                throw new \Exception($iyzicoSubMerchant->getErrorMessage());
            }
        }

        return $subMerchant;
    }

    private function setRequestParams($request, $store)
    {
        $request->setLocale(setting_value('streams::default_locale'));
        $request->setAddress($store->address);
        $request->setContactName($store->user->first_name);
        $request->setContactSurname($store->user->last_name);
        $request->setEmail($store->user->email);
        $request->setGsmNumber($store->user->gsm_phone);
        $request->setName($store->name);
        $request->setIban(preg_replace('/\s+/', '', $store->iban_number));
        $request->setIdentityNumber($store->user->identification_number);
        $request->setCurrency(setting_value('streams::currency'));

        return $request;
    }
}
