<?php namespace Visiosoft\PaymentIyzicompModule\Listeners;

use Visiosoft\PaymentIyzicoModule\Events\IyziciPaymentCreated;
use Visiosoft\PaymentIyzicompModule\PaymentItem\PaymentItemRepository;

class CreatePaymentItems
{

    private $paymentItemRepository;

    public function __construct(PaymentItemRepository $paymentItemRepository)
    {
        $this->paymentItemRepository = $paymentItemRepository;
    }

    public function handle(IyziciPaymentCreated $event)
    {
        $threedsPayment = $event->getThreedsPayment();
        foreach ($threedsPayment->getPaymentItems() as $paymentItem) {
            if ($paymentItem->getSubMerchantKey()) {
                $this->paymentItemRepository->create([
                    'order_detail_id' => $paymentItem->getItemId(),
                    'payment_transaction_id' => $paymentItem->getPaymentTransactionId(),
                ]);
            }
        }
    }
}
