<?php namespace Visiosoft\PaymentIyzicompModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\PaymentIyzicompModule\PaymentItem\Contract\PaymentItemRepositoryInterface;
use Visiosoft\PaymentIyzicompModule\Submerchant\Contract\SubmerchantRepositoryInterface;

class SubmerchantsController extends PublicController
{

    private $submerchantRepository;
    private $paymentItemRepository;

    public function __construct(
        SubmerchantRepositoryInterface $submerchantRepository,
        PaymentItemRepositoryInterface $paymentItemRepository
    )
    {
        parent::__construct();
        $this->submerchantRepository = $submerchantRepository;
        $this->paymentItemRepository = $paymentItemRepository;
    }

    public function getSubmerchant($store, $options)
    {
        // Check required fields
        if (!$store->iban_number) {
            throw new \Exception(trans('visiosoft.module.payment_iyzicomp::message.store_uncompleted_info', ['missing' => 'iban']));
        } elseif (!$store->user->identification_number) {
            throw new \Exception(trans('visiosoft.module.payment_iyzicomp::message.store_owner_uncompleted_info',
	            ['missing' => trans('visiosoft.module.payment_iyzicomp::field.user_id')]));
        }

        $subMerchant = $this->submerchantRepository->findBy('store_id', $store->id);
        if (!$subMerchant) {
            $subMerchant = $this->submerchantRepository->create([
                'store_id' => $store->id,
            ]);

            $request = new \Iyzipay\Request\CreateSubMerchantRequest();
            $request->setLocale(setting_value('streams::default_locale'));
            $request->setSubMerchantExternalId($subMerchant->id);
            $request->setSubMerchantType(\Iyzipay\Model\SubMerchantType::PERSONAL);
            $request->setAddress($store->address);
            $request->setContactName($store->user->first_name);
            $request->setContactSurname($store->user->last_name);
            $request->setEmail($store->user->email);
            $request->setGsmNumber($store->user->gsm_phone);
            $request->setName($store->name);
            $request->setIban($store->iban_number);
            $request->setIdentityNumber($store->user->identification_number);
            $request->setCurrency(setting_value('streams::currency'));
            $iyzicoSubMerchant = \Iyzipay\Model\SubMerchant::create($request, $options);

            if ($iyzicoSubMerchant->getStatus() === 'failure') {
                $subMerchant->delete();
                throw new \Exception($iyzicoSubMerchant->getErrorMessage());
            } else {
                $subMerchant->update([
                    'key' => $iyzicoSubMerchant->getSubMerchantKey()
                ]);
            }
        }

        return $subMerchant;
    }
}
