<?php namespace Visiosoft\PaymentIyzicompModule\Listeners;

use Visiosoft\OrdersModule\Events\OrderDelivered;
use Visiosoft\PaymentIyzicompModule\PaymentItem\PaymentItemRepository;

class CreateApprovalRequest
{

    private $paymentItemRepository;

    public function __construct(PaymentItemRepository $paymentItemRepository)
    {
        $this->paymentItemRepository = $paymentItemRepository;
    }

    public function handle(OrderDelivered $event)
    {
        $orderDetailId = $event->getOrderDetailId();
        $paymentItem = $this->paymentItemRepository->findBy('order_detail_id', $orderDetailId);

        if ($paymentItem) {
            $paymentTransactionId = $paymentItem->payment_transaction_id;

            $options = new \Iyzipay\Options();
            $options->setApiKey(setting_value('visiosoft.module.payment_iyzico::iyzico_setApiKey'));
            $options->setSecretKey(setting_value('visiosoft.module.payment_iyzico::iyzico_setSecretKey'));
            $options->setBaseUrl(setting_value('visiosoft.module.payment_iyzico::iyzico_setBaseUrl'));

            $request = new \Iyzipay\Request\CreateApprovalRequest();
            $request->setLocale(setting_value('streams::default_locale'));
            $request->setPaymentTransactionId($paymentTransactionId);
            $approval = \Iyzipay\Model\Approval::create($request, $options);

            if ($approval->getStatus() == 'failure') {
                throw new \Exception($approval->getErrorMessage());
            }
        }
    }
}
