<?php namespace Visiosoft\PaymentIyzicoModule;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;

class PaymentIyzicoModuleSeeder extends Seeder
{
    public function run()
    {if (is_module_installed('visiosoft.module.notifications')) {
            $template_repo = app(TemplateRepositoryInterface::class);
            $template = $template_repo->findBySlug('iyzico_errors_for_admin');
            if (!$template) {
                $template_repo->create([
                    'en' => [
                        'message' => '
                            <h1>IYZICO System Message</h1>
                            <p>Message:{message}</p>
                            <p>Product: <a href="{entry_url}">{entry_title}</a></p>
                            <p>Auth Uset: {auth_email}</p>
                        ',
                        'name' => 'Iyzico System Error Reports for Admin',
                        'greeting' => 'Something went wrong!',
                        'subject' => 'IYZICO System Message'
                    ],
                    'tr' => [
                        'message' => '
                            <h1>IYZICO Sistem Mesajı</h1>
                            <p>Mesaj:{message}</p>
                            <p>Ürün: <a href="{entry_url}">{entry_title}</a></p>
                            <p>Aktif Kullanıcı: {auth_email}</p>
                        ',
                        'name' => 'Admin için Iyzico Sistem Hata Bildirimleri',
                        'greeting' => 'Bir hata oluştu!',
                        'subject' => 'IYZICO Sistem Mesajı'
                    ],
                    'stream' => '',
                    'slug' => 'iyzico_errors_for_admin',
                ]);
            }
        }
    }
}
