<?php namespace Visiosoft\PaymentIyzicoModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\CartsModule\Cart\Event\CartsPay;
use Visiosoft\PaymentIyzicoModule\Listener\PaymentType;

class PaymentIyzicoModuleServiceProvider extends AddonServiceProvider
{
    protected $routes = [
        'payment/iyzico' => [
            'middleware' => 'auth',
            'as' => 'visiosoft.module.payment_iyzico::payment.iyzico',
            'uses' => 'Visiosoft\PaymentIyzicoModule\Http\Controller\IyzicoController@paymentForm',
        ],
        'payment/iyzico/respond' => [
            'as' => 'visiosoft.module.payment_iyzico::respond',
            'uses' => 'Visiosoft\PaymentIyzicoModule\Http\Controller\IyzicoController@paymentIyzico',
        ],
        'payment/return' => 'Visiosoft\PaymentIyzicoModule\Http\Controller\IyzicoController@returnIyzico',
    ];

    protected $listeners = [
        CartsPay::class => [
            PaymentType::class,
        ]
    ];
}
