<?php namespace Visiosoft\PaymentIyzicoModule\Http\Controller;

use Anomaly\CountryFieldType\Location\LocationModel;
use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Support\Facades\Auth;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\CartsModule\Cart\Command\TotalCart;
use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Omnipay\Omnipay;
use Omnipay\Common\CreditCard;
use Illuminate\Http\Request;
use Visiosoft\LocationModule\City\CityModel;
use Visiosoft\LocationModule\Country\CountryModel;
use Visiosoft\OrdersModule\Order\OrderModel;
use Visiosoft\OrdersModule\Test\Unit\Order\OrderModelTest;
use Visiosoft\ProfileModule\Adress\AdressModel;
use Visiosoft\ProfileModule\Profile\ProfileModel;

/**
 * Class CartsController
 *
 * @link          http://openclassify.com/
 * @author        OpenClassify, Inc. <support@openclassify.com>
 * @author        Visiosoft Inc <support@openclassify.com>
 * @package       Visiosoft\CartsModule\Http\Controller
 */
class IyzicoController extends PublicController
{
    public function paymentForm()
    {
        return $this->view->make('visiosoft.module.payment_iyzico::iyzico/form');
    }

    public function paymentIyzico(Request $request, SettingRepositoryInterface $settings)
    {
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }
        $OrderModel = new OrderModel();
        $Order = $OrderModel->getLastOrderByUser();
        $AddressModel = new AdressModel();
        $address = $AddressModel->getAdress($Order->bill_address_id)->first();
        $CountryModel = new CountryModel();
        $country = $CountryModel->getCountry($address->country_id);
        $CityModel = new CityModel();
        $city = $CityModel->getCities($address->city);
        $cart = $this->dispatch(new GetCart());
        $this->dispatch(new TotalCart($cart));
        $gateway = Omnipay::create('Iyzico');
        $formInputData = array(
            'name' => $address->adress_first_name,
            'lastname' => $address->adress_last_name,
            'number' => $request->ccno,
            'expiryMonth' => $request->expirationdateM,
            'expiryYear' => $request->expirationdateY,
            'cvv' => $request->ccv,
            'billingCity' => $city->name,
            'billingAddress1' => $address->adress_content,
            'billingCountry' => $country->name,
            'email' => auth()->user()->email,
            'postCode' => $address->adress_post_code
        );
        $card = new CreditCard($formInputData);

        $request = $gateway->authorize(['identityNumber' => $settings->value('visiosoft.module.payment_iyzico::iyzico_identityNumber')]);
        $request->setCard($card);
        $request->setApiKey($settings->value('visiosoft.module.payment_iyzico::iyzico_setApiKey'));
        $request->setSecretKey($settings->value('visiosoft.module.payment_iyzico::iyzico_setSecretKey'));
        $basket = new \Omnipay\Common\ItemBag();
        $item = new \Omnipay\Common\Item(['name' => 'items', 'price' => $cart->total]);
        $basket->add($item);

        $request->setItems($basket);

        //Stock Control
        foreach ($cart->items as $item) {
            if ($item->entry_type == 'Visiosoft\AdvsModule\Adv\AdvModel') {
                $advModel = new AdvModel();
                $response_control = $advModel->stockControl($item->entry_id, $item->quantity);
                if ($response_control == "false") {
                    return redirect('/cart');
                    die;
                }
            }
        }

        $response = $request->send();
        if ($response->isSuccessful()) {
            return redirect('payment/success/iyzico');
        } else {
            return redirect('payment/fail');
        }
    }
}
