<?php namespace Visiosoft\PaymentIyzicoModule\Http\Controller;

use Anomaly\CountryFieldType\Location\LocationModel;
use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Support\Facades\Auth;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\CartsModule\Cart\Command\TotalCart;
use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Omnipay\Omnipay;
use Omnipay\Common\CreditCard;
use Illuminate\Http\Request;
use Visiosoft\LocationModule\City\CityModel;
use Visiosoft\LocationModule\Country\CountryModel;
use Visiosoft\OrdersModule\Order\OrderModel;
use Visiosoft\OrdersModule\Test\Unit\Order\OrderModelTest;
use Visiosoft\ProfileModule\Adress\AdressModel;
use Visiosoft\ProfileModule\Adress\Command\GetAddress;

/**
 * Class CartsController
 *
 * @link          http://openclassify.com/
 * @author        OpenClassify, Inc. <support@openclassify.com>
 * @author        Visiosoft Inc <support@openclassify.com>
 * @package       Visiosoft\CartsModule\Http\Controller
 */
class IyzicoController extends PublicController
{
    private $order_model;
    private $address_model;
    private $country_model;
    private $city_model;
    private $settings;

    public function __construct(
        OrderModel $orderModel,
        AdressModel $adressModel,
        CityModel $cityModel,
        SettingRepositoryInterface $settingRepository,
        CountryModel $countryModel
    )
    {
        $this->order_model = $orderModel;
        $this->address_model = $adressModel;
        $this->country_model = $countryModel;
        $this->city_model = $cityModel;
        $this->settings = $settingRepository;
        parent::__construct();
    }

    public function paymentForm()
    {
        $delivery_id = $this->request->cookie('delivery');
        return $this->view->make('visiosoft.module.payment_iyzico::iyzico/form', compact('delivery_id'));
    }

    public function paymentIyzico()
    {
        $bill_id = $this->request->cookie('bill');

        $address = $this->address_model->getAdress($bill_id)->first();
        $country = $this->country_model->getCountry($address->country_id);
        $city = $this->city_model->getCities($address->city);

        $expiration = explode('/', $this->request->expiration);

        $cart = $this->dispatch(new GetCart());
        $this->dispatch(new TotalCart($cart));

        $request = new \Iyzipay\Request\CreatePaymentRequest();
        $request->setLocale(setting_value('streams::default_locale'));
        $request->setPrice($cart->total);
        $request->setPaidPrice($cart->total);
        $request->setCurrency(setting_value('streams::currency'));
        $request->setInstallment(1);
        $request->setCallbackUrl(url('payment/return'));


        $paymentCard = new \Iyzipay\Model\PaymentCard();
        $paymentCard->setCardHolderName($address->adress_first_name . ' ' . $address->adress_last_name);
        $paymentCard->setCardNumber(str_replace(' ', '', $this->request->ccno));
        $paymentCard->setExpireMonth(array_first($expiration));
        $paymentCard->setExpireYear(end($expiration));
        $paymentCard->setCvc($this->request->ccv);
        $paymentCard->setRegisterCard(0);

        $request->setPaymentCard($paymentCard);

        $buyer = new \Iyzipay\Model\Buyer();
        $buyer->setId(Auth::id());
        $buyer->setName($address->adress_first_name);
        $buyer->setSurname($address->adress_last_name);
        $buyer->setEmail(Auth::user()->email);
        $buyer->setIdentityNumber("12312312312");
        $buyer->setRegistrationAddress($address->adress_content);
        $buyer->setCity($city->name);
        $buyer->setCountry($country->name);

        $request->setBuyer($buyer);


        $billingAddress = new \Iyzipay\Model\Address();
        $billingAddress->setContactName($address->adress_first_name . ' ' . $address->adress_last_name);
        $billingAddress->setCity($city->name);
        $billingAddress->setCountry($country->name);
        $billingAddress->setAddress($address->adress_content);

        $request->setBillingAddress($billingAddress);

        $firstBasketItem = new \Iyzipay\Model\BasketItem();
        $firstBasketItem->setId("BI101");
        $firstBasketItem->setName("Item");
        $firstBasketItem->setCategory1("VIRTUAL");
        $firstBasketItem->setItemType(\Iyzipay\Model\BasketItemType::VIRTUAL);
        $firstBasketItem->setPrice($cart->total);
        $basketItems[0] = $firstBasketItem;

        $request->setBasketItems($basketItems);

        $options = new \Iyzipay\Options();
        $options->setApiKey($this->settings->value('visiosoft.module.payment_iyzico::iyzico_setApiKey'));
        $options->setSecretKey($this->settings->value('visiosoft.module.payment_iyzico::iyzico_setSecretKey'));
        $options->setBaseUrl($this->settings->value('visiosoft.module.payment_iyzico::iyzico_setBaseUrl'));

        $threedsInitialize = \Iyzipay\Model\ThreedsInitialize::create($request, $options);
        if ($threedsInitialize->getStatus() == "failure") {
            return back()->with('error', [$threedsInitialize->getErrorMessage()]);
        }
        $htmli = $threedsInitialize->getHtmlContent();
        return $this->view->make('visiosoft.module.payment_iyzico::iyzico/redirect', compact('htmli'));


    }

    public function returnIyzico()
    {
        $options = new \Iyzipay\Options();
        $options->setApiKey($this->settings->value('visiosoft.module.payment_iyzico::iyzico_setApiKey'));
        $options->setSecretKey($this->settings->value('visiosoft.module.payment_iyzico::iyzico_setSecretKey'));
        $options->setBaseUrl($this->settings->value('visiosoft.module.payment_iyzico::iyzico_setBaseUrl'));
        $pID = $this->request->paymentId;
        $request = new \Iyzipay\Request\CreateThreedsPaymentRequest();
        $request->setLocale(\Iyzipay\Model\Locale::TR);
        $request->setPaymentId($pID);
        $threedsPayment = \Iyzipay\Model\ThreedsPayment::create($request, $options);

        if ($threedsPayment->getStatus() == 'success') {
            return redirect('payment/success/iyzico');
        } else {
            $message = $threedsPayment->getErrorMessage();
            return redirect('payment/fail')->with('message', $message);
        }
    }
}
