<?php namespace Visiosoft\PaymentIyzicoModule\Http\Controller;

use Anomaly\CountryFieldType\Location\LocationModel;
use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Support\Facades\Auth;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\CartsModule\Cart\Command\TotalCart;
use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Omnipay\Omnipay;
use Omnipay\Common\CreditCard;
use Illuminate\Http\Request;
use Visiosoft\LocationModule\City\CityModel;
use Visiosoft\LocationModule\Country\CountryModel;
use Visiosoft\OrdersModule\Order\OrderModel;
use Visiosoft\OrdersModule\Test\Unit\Order\OrderModelTest;
use Visiosoft\ProfileModule\Adress\AdressModel;

/**
 * Class CartsController
 *
 * @link          http://openclassify.com/
 * @author        OpenClassify, Inc. <support@openclassify.com>
 * @author        Visiosoft Inc <support@openclassify.com>
 * @package       Visiosoft\CartsModule\Http\Controller
 */
class IyzicoController extends PublicController
{
    private $order_model;

    public function __construct(OrderModel $orderModel)
    {
        $this->order_model = $orderModel;
        parent::__construct();
    }

    public function paymentForm()
    {
        $order = $this->order_model->getLastOrderByUser();
        return $this->view->make('visiosoft.module.payment_iyzico::iyzico/form', compact('order'));
    }

    public function paymentIyzico(Request $req, SettingRepositoryInterface $settings)
    {
        $expiration = explode('/', $req->expiration);
        $Order = $this->order_model->getLastOrderByUser();
        $AddressModel = new AdressModel();
        $address = $AddressModel->getAdress($Order->bill_address_id)->first();
        $CountryModel = new CountryModel();
        $country = $CountryModel->getCountry($address->country_id);
        $CityModel = new CityModel();
        $city = $CityModel->getCities($address->city);
        $cart = $this->dispatch(new GetCart());
        $this->dispatch(new TotalCart($cart));
        
        $request = new \Iyzipay\Request\CreatePaymentRequest();
        $request->setLocale(setting_value('streams::default_locale'));
        $request->setPrice($cart->total);
        $request->setPaidPrice($cart->total);
        $request->setCurrency(setting_value('streams::currency'));
        $request->setInstallment(1);
        $request->setCallbackUrl(url('payment/return'));
        $paymentCard = new \Iyzipay\Model\PaymentCard();
        $paymentCard->setCardHolderName($address->adress_first_name . ' ' . $address->adress_last_name);
        $paymentCard->setCardNumber(str_replace(' ', '', $req->ccno));
        $paymentCard->setExpireMonth(array_first($expiration));
        $paymentCard->setExpireYear(end($expiration));
        $paymentCard->setCvc($req->ccv);
        $paymentCard->setRegisterCard(0);
        $request->setPaymentCard($paymentCard);
        $buyer = new \Iyzipay\Model\Buyer();
        $buyer->setId($address->user_no_id);
        $buyer->setName($address->adress_first_name);
        $buyer->setSurname($address->adress_last_name);
        $buyer->setEmail(Auth::user()->email);
        $buyer->setIdentityNumber("12312312312");
        $buyer->setRegistrationAddress($address->adress_content);
        $buyer->setCity($city->name);
        $buyer->setCountry($country->name);
        $request->setBuyer($buyer);
        $billingAddress = new \Iyzipay\Model\Address();
        $billingAddress->setContactName($address->adress_first_name . ' ' . $address->adress_last_name);
        $billingAddress->setCity($city->name);
        $billingAddress->setCountry($country->name);
        $billingAddress->setAddress($address->adress_content);;
        $request->setBillingAddress($billingAddress);
        $firstBasketItem = new \Iyzipay\Model\BasketItem();
        $firstBasketItem->setId("BI101");
        $firstBasketItem->setName("Item");
        $firstBasketItem->setCategory1("VIRTUAL");
        $firstBasketItem->setItemType(\Iyzipay\Model\BasketItemType::VIRTUAL);
        $firstBasketItem->setPrice($cart->total);
        $basketItems[0] = $firstBasketItem;
        $request->setBasketItems($basketItems);

        $options = new \Iyzipay\Options();
        $options->setApiKey($settings->value('visiosoft.module.payment_iyzico::iyzico_setApiKey'));
        $options->setSecretKey($settings->value('visiosoft.module.payment_iyzico::iyzico_setSecretKey'));
        $options->setBaseUrl($settings->value('visiosoft.module.payment_iyzico::iyzico_setBaseUrl'));

        $threedsInitialize = \Iyzipay\Model\ThreedsInitialize::create($request, $options);
        if ($threedsInitialize->getStatus() == "failure") {
            return back()->with('error', [$threedsInitialize->getErrorMessage()]);
        }
        $htmli = $threedsInitialize->getHtmlContent();
        return $this->view->make('visiosoft.module.payment_iyzico::iyzico/redirect', compact('htmli'));


    }

    public function paymentIyzico1(Request $request, SettingRepositoryInterface $settings)
    {
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }
        $OrderModel = new OrderModel();
        $Order = $OrderModel->getLastOrderByUser();
        $AddressModel = new AdressModel();
        $address = $AddressModel->getAdress($Order->bill_address_id)->first();
        $CountryModel = new CountryModel();
        $country = $CountryModel->getCountry($address->country_id);
        $CityModel = new CityModel();
        $city = $CityModel->getCities($address->city);
        $cart = $this->dispatch(new GetCart());
        $this->dispatch(new TotalCart($cart));
        $gateway = Omnipay::create('Iyzico');
        $formInputData = array(
            'name' => $address->adress_first_name,
            'lastname' => $address->adress_last_name,
            'number' => str_replace(' ', '', $request->ccno),
            'expiryMonth' => $request->expirationdateM,
            'expiryYear' => $request->expirationdateY,
            'cvv' => $request->ccv,
            'billingCity' => $city->name,
            'billingAddress1' => $address->adress_content,
            'billingCountry' => $country->name,
            'email' => auth()->user()->email,
            'postCode' => $address->adress_post_code, 'callbackUrl' => 'http://aaaa.com'
        );
        $card = new CreditCard($formInputData);

        $request = $gateway->purchase(['identityNumber' => $settings->value('visiosoft.module.payment_iyzico::iyzico_identityNumber'), 'callbackUrl' => 'http://aaaa.com']);
        $request->setCard($card);
        $request->setApiKey($settings->value('visiosoft.module.payment_iyzico::iyzico_setApiKey'));
        $request->setSecretKey($settings->value('visiosoft.module.payment_iyzico::iyzico_setSecretKey'));

        $basket = new \Omnipay\Common\ItemBag();
        $item = new \Omnipay\Common\Item(['name' => 'items', 'price' => $cart->total]);
        $basket->add($item);

        $request->setItems($basket);

        //Stock Control
        foreach ($cart->items as $item) {
            if ($item->entry_type == 'Visiosoft\AdvsModule\Adv\AdvModel') {
                $advModel = new AdvModel();
                $response_control = $advModel->stockControl($item->entry_id, $item->quantity);
                if ($response_control == "false") {
                    return redirect('/cart');
                    die;
                }
            }
        }

        $response = $request->send();
        if ($response->isSuccessful()) {
            return redirect('payment/success/iyzico');
        } else {
            return redirect('payment/fail');
        }
    }

    public function returnIyzico(Request $request, SettingRepositoryInterface $settings)
    {
        $options = new \Iyzipay\Options();
        $options->setApiKey($settings->value('visiosoft.module.payment_iyzico::iyzico_setApiKey'));
        $options->setSecretKey($settings->value('visiosoft.module.payment_iyzico::iyzico_setSecretKey'));
        $options->setBaseUrl($settings->value('visiosoft.module.payment_iyzico::iyzico_setBaseUrl'));
        $pID = $request->paymentId;
        $request = new \Iyzipay\Request\CreateThreedsPaymentRequest();
        $request->setLocale(\Iyzipay\Model\Locale::TR);
        $request->setPaymentId($pID);
        $threedsPayment = \Iyzipay\Model\ThreedsPayment::create($request, $options);

        if ($threedsPayment->getStatus() == 'success') {
            return redirect('payment/success/iyzico');
        } else {
            return redirect('payment/fail');
        }
    }
}
