<?php namespace Visiosoft\PaymentModule\PaymentMethod;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Visiosoft\PaymentModule\PaymentMethod\Contract\PaymentMethodInterface;
use Anomaly\Streams\Platform\Model\Payment\PaymentPaymentMethodEntryModel;

class PaymentMethodModel extends PaymentPaymentMethodEntryModel implements PaymentMethodInterface
{

    protected $appends = [
        'company'
    ];

    public function getCardAttribute($value)
    {
        return json_decode($value, true);
    }

    public function getBillingDetailsAttribute($value)
    {
        return json_decode($value, true);
    }

    public function getCompanyAttribute()
    {
        $user = Auth::user();
        $userCompany = DB::table('company_users')->join('company_company', 'company_company.id', '=', 'company_users.company_id')
            ->where('company_users.user_id', $user->id)
            ->where('company_users.payment_method_id', $this->id)->first();
        if ($userCompany) {
            return $userCompany;
        }
        return null;
    }
}
