<?php namespace Visiosoft\PaymentModule\Helper;

class CommonHelper
{
    /**
     * @param int $duration
     * @return string (hh:mm:ss)
     */
    function format_duration(int $duration): string
    {
        return sprintf('%02d:%02d:%02d', ($duration / 3600), ($duration / 60 % 60), $duration % 60);
    }


    /**
     * @param string $userAgent
     * @return string (android | ios | web)
     */
    public function getDevicePlatform(string $userAgent): string
    {
        $platform = "web";

        $iphone = stripos($userAgent, "iPhone");
        $ipad = stripos($userAgent, "iPad");
        $android = stripos($userAgent, "Android");

        if ($ipad || $iphone) {
            $platform = "ios";
        } else if ($android) {
            $platform = "android";
        }

        return $platform;
    }

    public function propertyIsEmpty($property): bool
    {

        if (empty($property) || !$property || count($property) == 0) {
            return true;
        }

        return false;
    }

    /**
     * @param array | object | string $json
     * @param string $data
     * @return string
     */
    public function getDataInPaymentMethodJson($json, string $data): string
    {
        $filtered = "";
        if (is_object($json) && isset($json->$data)) {
            $filtered = $json->$data;
        }

        if (is_array($json) && isset($json[$data])) {
            $filtered = $json[$data];
        }

        if (gettype($json) === "string") {
            $json = json_decode($json);

            if (isset($json->$data)) {
                $filtered = $json->$data;
            }
        }

        return $filtered;
    }


}