<?php

return [
    'android_download_url' => [
        'type' => 'anomaly.field_type.text',
        'config' => [
            'default_value' => "https://play.google.com/store/"
        ]
    ],
    'ios_download_url' => [
        'type' => 'anomaly.field_type.text',
        'config' => [
            'default_value' => "https://apps.apple.com/tr/app/apple-store/"
        ]
    ],
    'payment_control_range' => [
        'type' => 'anomaly.field_type.integer',
        'config' => [
            'default_value' => 15
        ]
    ],
    'balance_limit' => [
        'type' => 'anomaly.field_type.integer',
        'config' => [
            'default_value' => 100
        ]
    ],
    'invoice' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => 1,
            'mode' => 'dropdown'
        ]
    ],
    'minimum_payable_amount' => [
        'type' => 'anomaly.field_type.decimal',
        'config' => [
            'default_value' => 100,
        ]
    ],
    'stripe_administration_fee_percent' => [
        'type' => 'anomaly.field_type.decimal',
        'config' => [
            'default_value' => 3,
        ]
    ],
    'stripe_administration_fee' => [
        'type' => 'anomaly.field_type.decimal',
        'config' => [
            'default_value' => 3.3,
        ]
    ],
    'fixed_administration_fee' => [
        'type' => 'anomaly.field_type.decimal',
        'config' => [
            'default_value' => 4.95,
        ]
    ],
    'monthly_company_membership_fee' => [
        'type' => 'anomaly.field_type.decimal',
        'config' => [
            'default_value' => 49
        ]
    ],
    'fixed_administration_fee_percent' => [
        'type' => 'anomaly.field_type.decimal',
        'config' => [
            'default_value' => 1.5
        ]
    ],
    'payment_provider' => [
        "type" => "anomaly.field_type.select",
        'config' => [
            "handler" => \Visiosoft\PaymentModule\Payment\SettingsHandler\PaymentHandler::class
        ],
    ],
    'card_save_provider' => [
        "type" => "anomaly.field_type.select",
        'config' => [
            "handler" => \Visiosoft\PaymentModule\Payment\SettingsHandler\CardSaveHandler::class
        ],
    ],
    'invoice_provider' => [
        "type" => "anomaly.field_type.select",
        'config' => [
            "handler" => \Visiosoft\PaymentModule\Payment\SettingsHandler\InvoiceHandler::class
        ],
    ],
    'automatic_withdrawal' => [
        'type' => 'anomaly.field_type.select',
        'config' => [
            'default_value' => true,
            'options' => [
                true => 'Enabled',
                false => 'Disabled'
            ]
        ]
    ],
    'automatic_withdrawal_try_interval' => [
        'type' => 'anomaly.field_type.integer',
        'config' => [
            'default_value' => 60
        ]
    ],
    'payment_priority' => [
        'type' => 'anomaly.field_type.select',
        'config' => [
            'default_value' => "default",
            'options' => [
                "company" => 'Company',
                "default" => 'Default'
            ]
        ]
    ],
    'check_credit_card_validity' => [
        'type' => 'anomaly.field_type.select',
        'config' => [
            'default_value' => true,
            'options' => [
                true => 'Enabled',
                false => 'Disabled'
            ]
        ]
    ],
    'unpaid_payment_reminder' => [
        'type' => 'anomaly.field_type.select',
        'config' => [
            'default_value' => false,
            'options' => [
                true => 'Enabled',
                false => 'Disabled'
            ],
        ]
    ],
    'unpaid_payment_reminder_type' => [
        'type' => 'anomaly.field_type.select',
        'config' => [
            'default_value' => 'remind_once',
            'options' => [
                'remind_once' => 'Remind Once',
                'remind_periodically' => 'Remind Periodically'
            ],
        ]
    ],
    'unpaid_payment_reminder_time' => [
        'type' => 'anomaly.field_type.integer',
        'config' => [
            'default_value' => 5,
        ]
    ],
    'unpaid_payment_reminder_interval' => [
        'type' => 'anomaly.field_type.integer',
        'config' => [
            'default_value' => 1440
        ]
    ]

];
