<?php namespace Visiosoft\PaymentModule\Http\Controller\Admin;

use Visiosoft\PaymentModule\Event\PaymentCreatedEvent;
use Visiosoft\PaymentModule\Helper\PaymentChannel;
use Visiosoft\PaymentModule\Payment\Form\PaymentFormBuilder;
use Visiosoft\PaymentModule\Payment\Table\PaymentTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class PaymentController extends AdminController
{


    public function index(PaymentTableBuilder $table)
    {
        return $table->render();
    }

    public function receive_payment($id)
    {

        try {
            event(new PaymentCreatedEvent($id, PaymentChannel::ADMIN));
        } catch (\Exception $e) {

            return redirect()->back()->with(['error' => ['message' => $e->getMessage()]]);
        }
        return $this->redirect->back();
    }


    public function create(PaymentFormBuilder $form)
    {
        return $form->render();
    }


    public function edit(PaymentFormBuilder $form, $id)
    {
        return $form->render($id);
    }
}
