<?php namespace Visiosoft\PaymentModule\Http\Controller;

use \Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Http\Request;
use Visiosoft\ConnectModule\Traits\ApiReturnResponseTrait;
use Visiosoft\ParkingModule\ParkingSession\Contract\ParkingSessionRepositoryInterface;
use Visiosoft\PaymentModule\Payment\Contract\PaymentRepositoryInterface;
use Visiosoft\PaymentStripeExtension\PaymentStripeExtension;

class PaymentController extends PublicController
{
    use ApiReturnResponseTrait;

    protected ParkingSessionRepositoryInterface $parkingSessionRepository;
    protected PaymentRepositoryInterface $paymentRepository;

    public function __construct(
        ParkingSessionRepositoryInterface $parkingSessionRepository,
        PaymentRepositoryInterface        $paymentRepository

    )
    {
        $this->parkingSessionRepository = $parkingSessionRepository;
        $this->paymentRepository = $paymentRepository;
        parent::__construct();
    }

    public function successPage(Request $request)
    {
        $inputs = $request->all();
        $sessionId = $inputs['session_id'];

        $stripeSuccessPageData = PaymentStripeExtension::checkoutSuccessPage($sessionId);

        $session = $this->parkingSessionRepository->newQuery()->find($stripeSuccessPageData['session']['client_reference_id']);
        if ($stripeSuccessPageData['session']['payment_status'] == 'paid') {
            $payment = $this->paymentRepository->newQuery()->find($session->payment_transaction_id);
            $payment->update(['status_id' => 2]);
        }
        $customerName = $stripeSuccessPageData['session']['customer_details']['name'];
        $customerEmail = $stripeSuccessPageData['session']['customer_details']['email'];
        return $this->sendResponse([
            'session' => $session,
            'payment' => $payment,
            'customer_name' => $customerName,
            'customer_email' => $customerEmail,
            'invoice_download_url' => ''
        ]);
    }
}