<?php namespace Visiosoft\PaymentModule\PaymentMethod;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Visiosoft\PaymentModule\PaymentMethod\Contract\PaymentMethodInterface;
use Anomaly\Streams\Platform\Model\Payment\PaymentPaymentMethodEntryModel;

class PaymentMethodModel extends PaymentPaymentMethodEntryModel implements PaymentMethodInterface
{

    protected $appends = [
        'company'
    ];

    public function getCardAttribute($value)
    {
        return json_decode($value, true);
    }

    public function getBillingDetailsAttribute($value)
    {
        return json_decode($value, true);
    }

    public function getCompanyAttribute()
    {
        $user = Auth::user();
        $userCompany = DB::table('company_employee')->join('company_company', 'company_company.id', '=', 'company_employee.company_id')
            ->where('company_employee.user_id', $user->id)
            ->where('company_employee.payment_method_id', $this->id)->first();
        if ($userCompany) {
            return $userCompany;
        }
        return null;
    }

    public function getLast4Digits()
    {
        if (isset($this->card['last4'])) {

            return $this->card['last4'];
        }

        return "";
    }

    public function getOwnerId()
    {
        return $this->owner_id;
    }

    public function getHolderName()
    {
        return $this->holder_name;
    }

    public function getCreatedAt()
    {
        return $this->created_at;
    }

}
