<?php namespace Visiosoft\PaymentModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Support\Carbon;
use Visiosoft\ChargingModule\Transaction\Contract\TransactionRepositoryInterface;
use Visiosoft\ConnectModule\Traits\ApiReturnResponseTrait;
use Visiosoft\PaymentModule\Payment\Contract\PaymentRepositoryInterface;
use Visiosoft\PaymentModule\Status\Contract\StatusRepositoryInterface;
use Visiosoft\StationModule\Station\Contract\StationRepositoryInterface;

class PaymentController extends PublicController
{
    use ApiReturnResponseTrait;

    protected PaymentRepositoryInterface $paymentRepository;
    protected TransactionRepositoryInterface $transactionRepository;
    protected StationRepositoryInterface $stationRepository;

    public function __construct(
        PaymentRepositoryInterface          $paymentRepository,
        TransactionRepositoryInterface      $transactionRepository,
        StationRepositoryInterface          $stationRepository
    )
    {
        $this->paymentRepository = $paymentRepository;
        $this->transactionRepository = $transactionRepository;
        $this->stationRepository = $stationRepository;
        parent::__construct();
    }
    public function checkPendingPayment()
    {
        $control_range = setting_value('visiosoft.module.payment::payment_control_range');
        $query_time = Carbon::now()->subMinute($control_range);
        $statusRepository = app(StatusRepositoryInterface::class);
        $status_id = $statusRepository->findBySlug('unpaid')->getId();

        $payments = $this->paymentRepository->newQuery()
            ->where('created_at', '<', $query_time->toDateTimeString())
            ->whereHas('status', function ($q) {
                $q->whereIn('slug', ['pending']);
            })->each(function ($payment) use ($status_id) {
                $payment->status = $status_id;
                $payment->save();
            }, 1000);
    }

}