$(document).ready(function () {

// User filter
    $("select[name=filter_user]").select2({
        placeholder: $('select[name=filter_user] option:first-child').text(),
        ajax: {
            url: '/api/users/search',
            dataType: 'json',
            processResults: function (data) {
                let formattedData = [];

                Object.keys(data).forEach(function (id) {
                    let firstName = data[id].first_name ? data[id].first_name : 'Unknown';
                    let lastName = data[id].last_name ? data[id].last_name : 'Unknown';
                    let phone = data[id].phone


                    formattedData.push({
                        'id': data[id].id,
                        'text': firstName + ' ' + lastName + ' ' + phone
                    })
                });

                return {
                    results: formattedData
                }
            }
        }
    });
});