<?php namespace Visiosoft\PaymentModule\Listener;

use Monolog\Handler\StreamHandler;
use Monolog\Logger;
use Visiosoft\PaymentModule\Event\CreateInvoiceEvent;
use Visiosoft\PaymentModule\Payment\Commands\Invoice;

class CreateInvoiceListener
{
    public function handle(CreateInvoiceEvent $event)
    {
        try {
            $invoice = new Invoice();
            $invoice->createInvoice($event->paymentID);
        } catch (\Exception $e) {
            $log = new Logger('create_invoice_listener');
            $log->pushHandler(new StreamHandler(storage_path('logs/create_invoice_listener.log')), Logger::ERROR);
            $log->error($e);
        }
    }
}
