<?php namespace Visiosoft\PaymentModule\Console\Command;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Visiosoft\PaymentModule\Event\PaymentCreatedEvent;
use Visiosoft\PaymentModule\Helper\CommonHelper;

class AutoPaymentCommand extends Command
{
    protected $signature = 'payment:auto_payment';
    protected $description = 'A cron for automatic payment';
    protected $helper;
    protected $userID;

    public function __construct($userID = null)
    {
        $this->helper = app(CommonHelper::class);
        $this->userID = $userID;
        parent::__construct();
    }

    public function handle()
    {
        $automaticWithdrawal = setting_value('visiosoft.module.payment::automatic_withdrawal');
        if ($automaticWithdrawal) {
            $unpaidPayments = $this->getUnpaidPayments($this->userID);
            if (!$this->helper->propertyIsEmpty($unpaidPayments)) {
                foreach ($unpaidPayments as $unpaidPayment) {
                    event(new PaymentCreatedEvent($unpaidPayment->id));
                }
            }
        }
    }

    protected function getUnpaidPayments($userID = null, $limit = 100)
    {
        $tryInterval = setting_value('visiosoft.module.payment::automatic_withdrawal_try_interval');
        $nowMinusTryInterval = date('Y-m-d H:i:s', strtotime('-' . $tryInterval . ' minutes', time()));
        $unpaidPayments = DB::table('payment_payment')
            ->whereIn('status_id', ['1','4']) //status_id[1] = pending, status_id[4] = failed
            ->whereNull('deleted_at');

        if (!empty($userID)) {
            $unpaidPayments->where('user_id', $userID);
        } else {
            $unpaidPayments->where(function ($query) use ($nowMinusTryInterval) {
                $query->whereNull('last_try')
                    ->orWhere('last_try', '<', $nowMinusTryInterval);
            });
        }

        return $unpaidPayments->limit($limit)->get();

    }
}
