<?php

namespace Visiosoft\PaymentModule\Job;

use Carbon\Carbon;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Visiosoft\PaymentModule\Event\UnpaidPaymentEvent;
use Visiosoft\PaymentModule\Event\UnpaidPaymentReminderEvent;
use Visiosoft\PaymentModule\Payment\Contract\PaymentRepositoryInterface;

class UnpaidPaymentControlJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function handle()
    {
        $paymentRepository = app(PaymentRepositoryInterface::class);
        $unpaidPayments = $paymentRepository->getPayments(true, null, ['unpaid', 'failed']);

        //Notify once or Periodically
        $remindType = setting_value('visiosoft.module.payment::unpaid_payment_reminder_type');

        //Minimum time to be reminded of payment
        $unpaidReminderTime = setting_value('visiosoft.module.payment::unpaid_payment_reminder_time');

        //Remind Interval
        $notificationInterval = setting_value('visiosoft.module.payment::unpaid_payment_reminder_interval');

        if ($remindType == "remind_once") {
            $unpaidPayments->whereNull('last_notify');
        }

        $unpaidPayments = $unpaidPayments->get();

        foreach ($unpaidPayments as $unpaidPayment) {
            $createdAt = Carbon::parse($unpaidPayment->created_at);
            $lastNotify = Carbon::parse($unpaidPayment->last_notify ?: $createdAt);
            $reminderTimeAdded = $createdAt->addMinute($unpaidReminderTime);
            $lastNotifyTimeAdded = $lastNotify->addMinute($notificationInterval);

            $now = Carbon::now();

            if ($unpaidPayment->amount > 0 && $now >= $reminderTimeAdded && $now >= $lastNotifyTimeAdded) {
                event(new UnpaidPaymentReminderEvent($unpaidPayment));
            }
        }
    }
}