<?php namespace Visiosoft\PaymentModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Model\Payment\PaymentStatusEntryModel;
use Visiosoft\PaymentModule\Event\InvoiceDownloadEvent;
use Visiosoft\PaymentModule\Listener\InvoiceDownloadListener;
use Visiosoft\PaymentModule\Listener\PaymentApprovedListener;
use Visiosoft\PaymentModule\Listener\PaymentCancelledListener;
use Visiosoft\PaymentModule\Listener\PaymentStartedListener;
use Visiosoft\PaymentModule\Listener\StirpePaymentChargeSucceededListener;
use Visiosoft\PaymentModule\Listener\StripePaymentIntentCreatedListener;
use Visiosoft\PaymentModule\PaymentMethod\Contract\PaymentMethodRepositoryInterface;
use Visiosoft\PaymentModule\PaymentMethod\PaymentMethodRepository;
use Anomaly\Streams\Platform\Model\Payment\PaymentPaymentMethodEntryModel;
use Visiosoft\PaymentModule\PaymentMethod\PaymentMethodModel;
use Visiosoft\PaymentModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\PaymentModule\Category\CategoryRepository;
use Anomaly\Streams\Platform\Model\Payment\PaymentCategoryEntryModel;
use Visiosoft\PaymentModule\Category\CategoryModel;
use Anomaly\Streams\Platform\Model\Payment\PaymentPaymentEntryModel;
use Illuminate\Routing\Router;
use Visiosoft\PaymentModule\Payment\Contract\PaymentRepositoryInterface;
use Visiosoft\PaymentModule\Payment\PaymentModel;
use Visiosoft\PaymentModule\Payment\PaymentRepository;
use Visiosoft\PaymentModule\Status\Contract\StatusRepositoryInterface;
use Visiosoft\PaymentModule\Status\StatusModel;
use Visiosoft\PaymentModule\Status\StatusRepository;
use Visiosoft\PaymentStripeExtension\Event\PaymentChargeSucceededEvent;
use Visiosoft\PaymentStripeExtension\Event\PaymentIntentCreatedEvent;
use Visiosoft\PaypalWebhooksExtension\Events\OrderApproved;
use Visiosoft\PaypalWebhooksExtension\Events\OrderCancelled;
use Visiosoft\PaypalWebhooksExtension\Events\PaymentStarted;

class PaymentModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        '/payment/cancel' => 'Visiosoft\PaymentModule\Http\Controller\PaymentController@cancelPage',
        '/payment/success' => 'Visiosoft\PaymentModule\Http\Controller\PaymentController@successPage',
        '/invoice/download/{stripePaymentIntent}' => 'Visiosoft\PaymentModule\Http\Controller\PaymentController@invoice',
        '/invoice/email/{stripePaymentIntent}' => 'Visiosoft\PaymentModule\Http\Controller\PaymentController@invoiceEmail',
        'admin/payment/payment_methods' => 'Visiosoft\PaymentModule\Http\Controller\Admin\PaymentMethodController@index',
        'admin/payment/payment_methods/create' => 'Visiosoft\PaymentModule\Http\Controller\Admin\PaymentMethodController@create',
        'admin/payment/payment_methods/edit/{id}' => 'Visiosoft\PaymentModule\Http\Controller\Admin\PaymentMethodController@edit',
        'admin/payment/category' => 'Visiosoft\PaymentModule\Http\Controller\Admin\CategoryController@index',
        'admin/payment/category/create' => 'Visiosoft\PaymentModule\Http\Controller\Admin\CategoryController@create',
        'admin/payment/category/edit/{id}' => 'Visiosoft\PaymentModule\Http\Controller\Admin\CategoryController@edit',
        'admin/payment' => 'Visiosoft\PaymentModule\Http\Controller\Admin\PaymentController@index',
        'admin/payment/create' => 'Visiosoft\PaymentModule\Http\Controller\Admin\PaymentController@create',
        'admin/payment/edit/{id}' => 'Visiosoft\PaymentModule\Http\Controller\Admin\PaymentController@edit',
        'admin/payment/status' => 'Visiosoft\PaymentModule\Http\Controller\Admin\StatusController@index',
        'admin/payment/status/create' => 'Visiosoft\PaymentModule\Http\Controller\Admin\StatusController@create',
        'admin/payment/status/edit/{id}' => 'Visiosoft\PaymentModule\Http\Controller\Admin\StatusController@edit',
        'cron/check-pending-payment' => 'Visiosoft\PaymentModule\Http\Controller\PaymentController@checkPendingPayment',
        'cron/check-balance-over-limit' => 'Visiosoft\PaymentModule\Http\Controller\PaymentController@checkBalanceOverLimit',
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\PaymentModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\PaymentModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        OrderApproved::class => [
            PaymentApprovedListener::class
        ],
        OrderCancelled::class => [
            PaymentCancelledListener::class
        ],
        PaymentStarted::class => [
            PaymentStartedListener::class
        ],
        PaymentIntentCreatedEvent::class => [
            StripePaymentIntentCreatedListener::class
        ],
        PaymentChargeSucceededEvent::class => [
            StirpePaymentChargeSucceededListener::class
        ],
        InvoiceDownloadEvent::class => [
            InvoiceDownloadListener::class
        ]
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\PaymentModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        PaymentPaymentMethodEntryModel::class => PaymentMethodModel::class,
        PaymentCategoryEntryModel::class => CategoryModel::class,
        PaymentPaymentEntryModel::class => PaymentModel::class,
        PaymentStatusEntryModel::class => StatusModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        PaymentMethodRepositoryInterface::class => PaymentMethodRepository::class,
        CategoryRepositoryInterface::class => CategoryRepository::class,
        PaymentRepositoryInterface::class => PaymentRepository::class,
        StatusRepositoryInterface::class => StatusRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        \Barryvdh\DomPDF\ServiceProvider::class,
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
