<?php namespace Visiosoft\PaymentModule;

use Anomaly\Streams\Platform\Addon\Module\Module;

class PaymentModule extends Module
{
    protected $root_menu;

    protected $navigation = true;

    protected $icon = 'fa fa-puzzle-piece';

    protected $sections = [
        'payment',
        'payment_methods',
        'category' => [
            'buttons' => [
                'new_category',
            ],
        ],
        'status'
    ];

    public function __construct()
    {
        $this->root_menu = env('APP_NAME', 'My App');
    }

    public function getFees($includedVatAmount)
    {
        $fixedAdministrationFee = setting_value('visiosoft.module.payment::fixed_administration_fee');
        $vatPercent = setting_value('visiosoft.module.invoice::vat');
        $fixedAdministrationFeePercent = setting_value('visiosoft.module.payment::fixed_administration_fee_percent');
        $output = [
            'total_amount_included_vat' => 0,
            'total_vat_amount' => 0,
            'payment_amount' => 0,
            'administration_fee' => 0,
            'administration_fee_vat_amount' => 0,
            'vat_percent' => $vatPercent
        ];
        if ($includedVatAmount > 0) {
            $administrationFee = (($fixedAdministrationFeePercent / 100) * $includedVatAmount) + $fixedAdministrationFee;
            $administrationFeeVatAmount = 0;
            $vatAmount = round($includedVatAmount - $includedVatAmount / (1 + ($vatPercent / 100)), 2);
            $totalVatAmount = $vatAmount + $administrationFeeVatAmount;
            $totalPaymentAmount = $includedVatAmount + $administrationFee;
            $output['total_amount_included_vat'] = round($includedVatAmount, 2);
            $output['total_vat_amount'] = round($totalVatAmount, 2);
            $output['payment_amount'] = round($totalPaymentAmount, 2);
            $output['administration_fee'] = round($administrationFee, 2);
            $output['administration_fee_vat_amount'] = $administrationFeeVatAmount;
        }
        return $output;
    }
}
