<?php namespace Visiosoft\PaymentModule\PaymentMethod\Table;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;

class PaymentMethodTableColumns
{

    public function handle(PaymentMethodTableBuilder $builder)
    {
        $columns = [
            'id' => [
                'wrapper' => '{entry.id}'
            ],
            'user' => [
                'wrapper' => '{value.name}',
                'value' => [
                    'name' => function (EntryInterface $entry, UserRepositoryInterface $userRepository) {
                        $user = $userRepository->find($entry->owner_id);
                        if ($user) {
                            return $user->first_name . ' ' . $user->last_name . ' ' . $user->phone;
                        }
                    }
                ]
            ],
            'service',
            'last_4_digits' => [
                'wrapper' => '{value.digits}',
                'value' => [
                    'digits' => function (EntryInterface $entry){
                            return $entry->card['last4'];
                    }
                ]
             ]
        ];
        $builder->setColumns($columns);
    }
}
