<?php namespace Visiosoft\PaymentModule\Payment;

use Anomaly\Streams\Platform\Model\Payment\PaymentPaymentEntryModel;
use Visiosoft\ChargingModule\Transaction\TransactionWithoutAttributeModel;
use Visiosoft\ParkingModule\Park\ParkWithoutAttributeModel;
use Visiosoft\ParkingModule\ParkingSession\ParkingSessionWithoutAttributeModel;
use Visiosoft\PaymentModule\Payment\Contract\PaymentInterface;
use Visiosoft\PaymentModule\PaymentModule;
use Visiosoft\StationModule\Station\StationWithoutAttributeModel;
use Visiosoft\VehicleModule\Vehicle\VehicleWithoutAttributeModel;

class PaymentWithoutAttrModel extends PaymentModel
{
    protected $appends = ['fees'];

    public function vehicle()
    {
        return $this->belongsTo(VehicleWithoutAttributeModel::class, 'vehicle_id');
    }

    public function parkSession()
    {
        return $this->belongsTo(ParkingSessionWithoutAttributeModel::class, 'park_session_id');
    }

    public function chargingTransaction()
    {
        return $this->belongsTo(TransactionWithoutAttributeModel::class, 'transaction_id');
    }

    public function park()
    {
        return $this->belongsTo(ParkWithoutAttributeModel::class, 'park_id');
    }

    public function station()
    {
        return $this->belongsTo(StationWithoutAttributeModel::class, 'station_id');
    }
}
