<?php

namespace Visiosoft\PaymentModule\Payment\Commands;

class Provider
{

    /**
     * @param bool $status
     * @param array $data
     * @param string|null $message
     * @param \Exception|null $e
     * @return array
     */

    public $provider;

    public function __construct($providerType)
    {
        try {
            $this->provider = $this->getProviders($providerType);
        }catch (\Exception $e){
            $this->formatOutput(false,[],"",$e);
        }
    }

    public function getProviders($providerType)
    {
        $providerCollection = setting_value('visiosoft.module.payment::' . $providerType);
        $provider = $this->getProviderByNamespace($providerCollection);
        // Checking if the providers are exists.
        if (!$provider) {
            throw new \Exception(trans('visiosoft.module.payment::message.provider_not_found'), 500);
        }
        return $provider;
    }

    /**
     * @param bool $status
     * @param array $data
     * @param string|null $message
     * @param \Exception|null $e
     * @return array
     */
    public function formatOutput(bool $status = true, array $data = [], string $message = null, \Exception $e = null): array
    {
        if (!$status && !empty($e)) {
            $message = 'Internal Error';
            if (config('app.debug')) {
                $message = 'Exception Error: ' . $e->getFile() . ' ' . $e->getLine() . ' ' . $e->getMessage();
            }
        }
        
        return [
            'status' => $status,
            'data' => $data,
            'message' => $message
        ];
    }

    public function getProviderSlug()
    {
        return $this->provider->getSlug();
    }

    public function getProviderByNamespace($namespace)
    {
        $extensions = app('extension.collection')->installed();
        $module = app('module.collection')->installed();

        return $extensions->get($namespace) ?? $module->get($namespace);
    }

}

?>