<?php

namespace Visiosoft\PaymentModule\Listener;

use Visiosoft\PaymentModule\Payment\Contract\PaymentRepositoryInterface;
use Visiosoft\PaymentModule\Status\Contract\StatusRepositoryInterface;
use Visiosoft\SwishModule\Event\PaymentCreatedEvent;

class SwishPaymentCreatedListener
{
    public function handle(PaymentCreatedEvent $event)
    {
        $values = $event->values;
        $paymentRepository = app(PaymentRepositoryInterface::class);
        $paymentStatusRepository = app(StatusRepositoryInterface::class);

        if (!$payment = $paymentRepository->find($values['payment_id']))
        {
            throw new \Exception(trans('visiosoft.module.connect::message.not_found', ['name' => trans('visiosoft.module.payment::field.payment.name')]));
        }

        $status = $paymentStatusRepository->findBySlug('pending');
        $payment->update(['payment_intent_id'=>$values['UUID'],'status_id' => $status->getId()]);
    }
}