<?php namespace Visiosoft\PaymentModule\Listener;

use Illuminate\Support\Facades\Notification;
use Visiosoft\PaymentModule\Event\InvoiceDownloadEvent;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Notification\MailTemplate;

class InvoiceDownloadListener
{
    private $template;

    public function __construct(TemplateRepositoryInterface $template)
    {
        $this->template = $template;
    }

    public function handle(InvoiceDownloadEvent $event)
    {
        $template = $this->template->findBySlug('park_session_invoice');
        if ($template) {
            $parameters = [
                'customer_name' => $event->customerName,
                'link' => $event->link,
            ];
            Notification::route('mail', $event->email)
                ->notify(new MailTemplate($template->getTemplateForArray($parameters)));
        }
    }
}