<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModulePaymentCreatePaymentFields extends Migration
{
    protected $fields = [
        'name' => 'anomaly.field_type.text',
        'slug' => [
            'type' => 'anomaly.field_type.slug',
            'config' => [
                'slugify' => 'name',
                'type' => '_'
            ]
        ],
        'user' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Anomaly\UsersModule\User\UserModel::class
            ]
        ],
        'transaction' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\ChargingModule\Transaction\TransactionModel::class
            ]
        ],
        'payment_intent_id' => 'anomaly.field_type.text',
        'usage' => 'anomaly.field_type.integer',
        'amount' => 'anomaly.field_type.text',
        'status' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\PaymentModule\Status\StatusModel::class
            ]
        ],
        'relateds' => 'anomaly.field_type.text',
        'park_session' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\ParkingModule\ParkingSession\ParkingSessionModel::class
            ]
        ],
        'currency' => [
            'type' => 'anomaly.field_type.select',
            'config' => [
                'handler' => 'currencies',
            ],
        ],
        'category' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\PaymentModule\Category\CategoryModel::class
            ]
        ],
        'payment_method' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' =>  \Visiosoft\PaymentModule\PaymentMethod\PaymentMethodModel::class
            ]
        ],
    ];

}
