<?php namespace Visiosoft\PaymentModule\Payment\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;
use Visiosoft\PaymentModule\Payment\PaymentWithoutAttrModel;

class PaymentTableBuilder extends TableBuilder
{

    /**
     * The table views.
     *
     * @var array|string
     */
    protected $views = [];

    /**
     * The table filters.
     *
     * @var array|string
     */
    protected $filters = [
        'user',
        'transaction',
        'status'
    ];

    protected $model = PaymentWithoutAttrModel::class;

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [
        'id' => ['wrapper' => '{entry.id}'],
        'user' =>
            ['wrapper' =>
                '{entry.user.first_name}'." ".
                '{entry.user.last_name}'." ".
                '{entry.user.phone}'
            ],
        'transaction',
        'payment_method',
        'status',
        'currency'
    ];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = ['edit'];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = ['delete'];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [];

    /**
     * The table assets.
     *
     * @var array
     */
    protected $assets = [];

}
