<?php

namespace Visiosoft\PaymentModule\Listener;

use Visiosoft\PaymentModule\Payment\Contract\PaymentRepositoryInterface;
use Visiosoft\PaymentStripeExtension\Event\PaymentChargeSucceededEvent;
use Visiosoft\PaymentStripeExtension\Event\PaymentIntentCreatedEvent;

class StirpePaymentChargeSucceededListener
{

    public function handle(PaymentChargeSucceededEvent $event)
    {
        $values = $event->values;
        $paymentRepository = app(PaymentRepositoryInterface::class);
        if (!$payment = $paymentRepository->newQuery()->where('stripe_intent_id', $values['data']['object']['payment_intent'])->first()) {
            throw new \Exception(trans('visiosoft.module.connect::message.not_found', ['name' => trans('visiosoft.module.payment::field.payment.name')]));
        }
        $payment->update(['status_id' => 2]);
    }
}