<?php namespace Visiosoft\PaymentModule\Console\Command;

use Illuminate\Console\Command;
use Visiosoft\PaymentModule\Job\AutoInvoiceJob;
use Visiosoft\PaymentModule\Payment\Contract\PaymentRepositoryInterface;
use Visiosoft\PaymentModule\Payment\PaymentWithoutAttrModel;
use function Clue\StreamFilter\fun;

class AutoInvoiceCommand extends Command
{
    protected $signature = 'invoice:auto';
    protected $description = 'auto charge over limit';

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        $paymentRepository = app(PaymentRepositoryInterface::class);
        $paymentIds = $paymentRepository->newQuery()
            ->whereNull('deleted_at')
            ->whereNull('invoice_id')
            ->where('status_id', 2)
            ->pluck('id');
        foreach ($paymentIds as $id) {
            $paymentRepository->createPaymentInvoice($id);
        }
    }
}
