<?php namespace Visiosoft\PaymentModule\Payment;

use Visiosoft\CurrencyModule\CurrencyModule;
use Visiosoft\PaymentModule\Payment\Contract\PaymentRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class PaymentRepository extends EntryRepository implements PaymentRepositoryInterface
{

    public string $currency;

    protected $model;

    public function __construct(PaymentModel $model)
    {
        $this->currency = CurrencyModule::getDefault()->symbol;
        $this->model = $model;
    }
}
