<?php namespace Visiosoft\PaymentModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Model\Payment\PaymentCategoryEntryModel;
use Anomaly\Streams\Platform\Model\Payment\PaymentPaymentEntryModel;
use Anomaly\Streams\Platform\Model\Payment\PaymentPaymentMethodEntryModel;
use Anomaly\Streams\Platform\Model\Payment\PaymentStatusEntryModel;
use Illuminate\Support\Facades\Route;
use Visiosoft\PaymentModule\Category\CategoryModel;
use Visiosoft\PaymentModule\Category\CategoryRepository;
use Visiosoft\PaymentModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\PaymentModule\Console\Command\AutoPaymentCommand;
use Visiosoft\PaymentModule\Console\Command\PaymentReminderCommand;
use Visiosoft\PaymentModule\Event\CreateInvoiceEvent;
use Visiosoft\PaymentModule\Event\InvoiceDownloadEvent;
use Visiosoft\PaymentModule\Listener\CardCreatedListener;
use Visiosoft\PaymentModule\Event\PaymentReceiptEvent;
use Visiosoft\PaymentModule\Listener\CreateInvoiceListener;
use Visiosoft\PaymentModule\Listener\InvoiceDownloadListener;
use Visiosoft\PaymentModule\Listener\CreateReceiptListener;
use Visiosoft\PaymentModule\Listener\PayCreatedListener;
use Visiosoft\PaymentModule\Listener\PaymentApprovedListener;
use Visiosoft\PaymentModule\Listener\PaymentCancelledListener;
use Visiosoft\PaymentModule\Listener\PaymentStartedListener;
use Visiosoft\PaymentModule\Listener\StirpePaymentChargeSucceededListener;
use Visiosoft\PaymentModule\Listener\StripePaymentIntentCreatedListener;
use Visiosoft\PaymentModule\Listener\SwishPaymentCreatedListener;
use Visiosoft\PaymentModule\Listener\SwishPaymentResultListener;
use Visiosoft\PaymentModule\Payment\Contract\PaymentRepositoryInterface;
use Visiosoft\PaymentModule\Payment\PaymentModel;
use Visiosoft\PaymentModule\Payment\PaymentObserver;
use Visiosoft\PaymentModule\Payment\PaymentRepository;
use Visiosoft\PaymentModule\PaymentMethod\Contract\PaymentMethodRepositoryInterface;
use Visiosoft\PaymentModule\PaymentMethod\Event\CardCreatedEvent;
use Visiosoft\PaymentModule\PaymentMethod\PaymentMethodModel;
use Visiosoft\PaymentModule\PaymentMethod\PaymentMethodRepository;
use Visiosoft\PaymentModule\Status\Contract\StatusRepositoryInterface;
use Visiosoft\PaymentModule\Status\StatusModel;
use Visiosoft\PaymentModule\Status\StatusRepository;
use Visiosoft\PaymentStripeExtension\Event\PaymentChargeSucceededEvent;
use Visiosoft\PaymentStripeExtension\Event\PaymentIntentCreatedEvent;
use Visiosoft\PaypalWebhooksExtension\Events\OrderApproved;
use Visiosoft\PaypalWebhooksExtension\Events\OrderCancelled;
use Visiosoft\PaypalWebhooksExtension\Events\PaymentStarted;
use Visiosoft\SwishModule\Event\PaymentCreatedEvent;
use Visiosoft\SwishModule\Event\PaymentResultEvent;

class PaymentModuleServiceProvider extends AddonServiceProvider
{
    protected $commands = [
        AutoPaymentCommand::class,
        PaymentReminderCommand::class
    ];

    public function map()
    {
        Route::group(['prefix' => "api/v2/admin"], function () {
            Route::group(['prefix' => "payment"], function () {
                Route::get('get-user-payments/{id}', 'Visiosoft\PaymentModule\Http\Controller\Api\V2\Admin\ApiController@getUserPayments');
                Route::get('get-user-payment-methods/{id}', 'Visiosoft\PaymentModule\Http\Controller\Api\V2\Admin\ApiController@getUserPaymentMethods');
            });
        });
    }

    protected $routes = [
        '/invoice/download/{stripePaymentIntent}' => 'Visiosoft\PaymentModule\Http\Controller\PaymentController@invoice',
        '/invoice/email/{stripePaymentIntent}' => 'Visiosoft\PaymentModule\Http\Controller\PaymentController@invoiceEmail',
        'admin/payment/payment_methods' => 'Visiosoft\PaymentModule\Http\Controller\Admin\PaymentMethodController@index',
        'admin/payment/payment_methods/create' => 'Visiosoft\PaymentModule\Http\Controller\Admin\PaymentMethodController@create',
        'admin/payment/payment_methods/edit/{id}' => 'Visiosoft\PaymentModule\Http\Controller\Admin\PaymentMethodController@edit',
        'admin/payment/category' => 'Visiosoft\PaymentModule\Http\Controller\Admin\CategoryController@index',
        'admin/payment/category/create' => 'Visiosoft\PaymentModule\Http\Controller\Admin\CategoryController@create',
        'admin/payment/category/edit/{id}' => 'Visiosoft\PaymentModule\Http\Controller\Admin\CategoryController@edit',
        'admin/payment' => 'Visiosoft\PaymentModule\Http\Controller\Admin\PaymentController@index',
        'admin/payment/create' => 'Visiosoft\PaymentModule\Http\Controller\Admin\PaymentController@create',
        'admin/payment/edit/{id}' => 'Visiosoft\PaymentModule\Http\Controller\Admin\PaymentController@edit',
        'admin/payment/status' => 'Visiosoft\PaymentModule\Http\Controller\Admin\StatusController@index',
        'admin/payment/status/create' => 'Visiosoft\PaymentModule\Http\Controller\Admin\StatusController@create',
        'admin/payment/status/edit/{id}' => 'Visiosoft\PaymentModule\Http\Controller\Admin\StatusController@edit',
        'cron/check-pending-payment' => 'Visiosoft\PaymentModule\Http\Controller\PaymentController@checkPendingPayment',
        'cron/check-balance-over-limit' => 'Visiosoft\PaymentModule\Http\Controller\PaymentController@checkBalanceOverLimit',
        'invoice' => 'Visiosoft\PaymentModule\PaymentModule@invoice',
        'pay-with-card' => 'Visiosoft\PaymentModule\Http\Controller\PaymentController@pay',
    ];

    protected $listeners = [
        OrderApproved::class => [
            PaymentApprovedListener::class
        ],
        OrderCancelled::class => [
            PaymentCancelledListener::class
        ],
        PaymentStarted::class => [
            PaymentStartedListener::class
        ],
        PaymentIntentCreatedEvent::class => [
            StripePaymentIntentCreatedListener::class
        ],
        PaymentChargeSucceededEvent::class => [
            StirpePaymentChargeSucceededListener::class
        ],
        \Visiosoft\PaymentModule\Event\PaymentCreatedEvent::class => [
            PayCreatedListener::class,
        ],
        CreateInvoiceEvent::class => [
            CreateInvoiceListener::class
        ],
        PaymentCreatedEvent::class => [
            SwishPaymentCreatedListener::class
        ],
        PaymentReceiptEvent::class => [
            CreateReceiptListener::class
        ],
        PaymentResultEvent::class => [
            SwishPaymentResultListener::class
        ],
        CardCreatedEvent::class => [
            CardCreatedListener::class
        ]
    ];

    protected $bindings = [
        PaymentPaymentMethodEntryModel::class => PaymentMethodModel::class,
        PaymentCategoryEntryModel::class => CategoryModel::class,
        PaymentPaymentEntryModel::class => PaymentModel::class,
        PaymentStatusEntryModel::class => StatusModel::class,
    ];

    protected $singletons = [
        PaymentMethodRepositoryInterface::class => PaymentMethodRepository::class,
        CategoryRepositoryInterface::class => CategoryRepository::class,
        PaymentRepositoryInterface::class => PaymentRepository::class,
        StatusRepositoryInterface::class => StatusRepository::class,
    ];

    protected $providers = [];

    public function boot()
    {
        PaymentModel::observe(PaymentObserver::class);
    }
}
