<?php namespace Visiosoft\PaymentModule\Http\Controller\Api\V2\Admin;

use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\ConnectModule\Traits\ApiReturnResponseTrait;
use Visiosoft\PaymentModule\Helper\Payment;
use Visiosoft\PaymentModule\Helper\PaymentMethod;
use Visiosoft\PaymentModule\Helper\PaymentMethods;
use Visiosoft\PaymentModule\Helper\Payments;
use Visiosoft\PaymentModule\Payment\Contract\PaymentRepositoryInterface;
use Visiosoft\PaymentModule\PaymentMethod\Contract\PaymentMethodRepositoryInterface;

class ApiController extends AdminController
{
    use ApiReturnResponseTrait;

    private PaymentRepositoryInterface $paymentRepository;
    private PaymentMethodRepositoryInterface $paymentMethodRepository;

    public function __construct()
    {
        $this->paymentRepository = app(PaymentRepositoryInterface::class);
        $this->paymentMethodRepository = app(PaymentMethodRepositoryInterface::class);
        parent::__construct();
    }

    public function getUserPayments(int $userId)
    {
        $payments = new Payments();
        $userPayments = $this->paymentRepository->getPayments(false, $userId);
        foreach ($userPayments as $userPayment) {
            $payments->setPayment(new Payment($userPayment));
        }
        return $this->sendResponse($payments->getPayments());
    }

    public function getUserPaymentMethods(int $userId)
    {
        $paymentMethods = new PaymentMethods();
        $userPaymentMethods = $this->paymentMethodRepository->getCardsByOwner($userId);
        foreach ($userPaymentMethods as $userPaymentMethod) {
            $paymentMethods->setPaymentMethod(new PaymentMethod($userPaymentMethod));
        }


        return $this->sendResponse($paymentMethods->getPaymentMethods());

    }


}