<?php

namespace Visiosoft\PaymentModule\Helper;

use Visiosoft\PaymentModule\Payment\Contract\PaymentInterface;
use Visiosoft\PaymentModule\PaymentMethod\Contract\PaymentMethodInterface;

class PaymentMethod
{
    public string $createdAt;
    public ?int $id;
    public ?int $userId;
    public ?string $holderName;
    public ?string $brand;
    public ?string $expirationMonth;
    public ?string $expirationYear;
    public ?string $status;
    public ?string $last4;

    public function __construct(PaymentMethodInterface $paymentMethod)
    {
        $this->createdAt = $paymentMethod->getCreatedAt();
        $this->id = $paymentMethod->getId();
        $this->userId = $paymentMethod->getOwnerId();
        $this->holderName = $paymentMethod->getHolderName();
        $this->brand = $paymentMethod->card['brand'];
        $this->expirationMonth = $paymentMethod->card['exp_month'];
        $this->expirationYear = $paymentMethod->card['exp_year'];
        $this->status = $paymentMethod->card['expired'];
        $this->last4 = $paymentMethod->card['last4'];
    }
}

